/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.xbeans;

import com.cognos.portal.xml.pipeline.PipelineException;
import com.ibm.cognos.internal.hts._1.LinkType;
import com.ibm.cognos.internal.hts._1.LinksListType;
import com.ibm.cognos.internal.hts._1.ManualTask;
import com.ibm.cognos.internal.hts._1.ManualTaskDescription;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TFrom;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TGroup;
import com.ibm.cognos.internal.hts.ws_ht.TGrouplist;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import com.ibm.cognos.internal.hts.ws_ht.TUser;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventState;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventType;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public abstract class BeplRequestFactory {
    protected static final String CONTENT_TEXT_PLAIN = "text/plain";
    protected static final String CONTENT_TEXT_HTML = "text/html";
    protected static final String DEFAULT_PRIORITY = "3";
    protected TPeopleAssignments peopleAssignments = TPeopleAssignments.Factory.newInstance();
    protected ManualTask manualTask = ManualTask.Factory.newInstance();
    protected LinksListType linksList;

    public BeplRequestFactory(String subject) throws IOException {
        this.manualTask.setSubject(subject);
        this.linksList = LinksListType.Factory.newInstance();
    }

    public void setStakeholders(String lpg, String[] stakeholders, String[] stakeholdersGroup) throws IOException {
        TGenericHumanRole genericHumanRole = TGenericHumanRole.Factory.newInstance();
        genericHumanRole.setFrom(this.createOrganizationalEntity(lpg, stakeholders, stakeholdersGroup));
        this.peopleAssignments.setTaskStakeholdersArray(new TGenericHumanRole[]{genericHumanRole});
    }

    public void setDescription(String descText, String descHtml) {
        ManualTaskDescription desc = this.manualTask.addNewDescription();
        XmlCursor cursor = desc.newCursor();
        cursor.toFirstContentToken();
        cursor.insertChars(descText);
        cursor.dispose();
        desc.setContentType(CONTENT_TEXT_PLAIN);
        ManualTaskDescription descHTML = this.manualTask.addNewDescription();
        XmlCursor cursorh = descHTML.newCursor();
        cursorh.toFirstContentToken();
        cursorh.insertChars(descHtml);
        cursorh.dispose();
        descHTML.setContentType(CONTENT_TEXT_HTML);
        this.manualTask.setDescriptionArray(new ManualTaskDescription[]{desc, descHTML});
    }

    public void addBusinessAdministratorGroup(String lpg, String[] businessAdministratorGroup) throws IOException {
        TGenericHumanRole businessAdministratorsGenericHumanRole = TGenericHumanRole.Factory.newInstance();
        TFrom tFrom = this.createOrganizationalEntity(lpg, new String[0], businessAdministratorGroup);
        businessAdministratorsGenericHumanRole.setFrom(tFrom);
        this.peopleAssignments.setBusinessAdministratorsArray(new TGenericHumanRole[]{businessAdministratorsGenericHumanRole});
    }

    public TFrom createOrganizationalEntity(String lpg, String[] users, String[] groups) throws IOException {
        OrganizationalEntityDocument orgEntDoc = OrganizationalEntityDocument.Factory.newInstance();
        TGenericHumanRole tgenhumanrole = TGenericHumanRole.Factory.newInstance();
        TOrganizationalEntity orgEnt = orgEntDoc.addNewOrganizationalEntity();
        if (groups != null && groups.length > 0) {
            TGrouplist groupList = orgEnt.addNewGroups();
            for (int i = 0; i < groups.length; ++i) {
                TGroup group = groupList.addNewGroup();
                group.setStringValue(groups[i]);
            }
            orgEnt.setGroupsArray(0, groupList);
        } else if (users != null && users.length > 0) {
            TUserlist userList = orgEnt.addNewUsers();
            for (int i = 0; i < users.length; ++i) {
                TUser user = userList.addNewUser();
                user.setStringValue(users[i]);
            }
            orgEnt.setUsersArray(0, userList);
        }
        TFrom from = tgenhumanrole.addNewFrom();
        from.setLogicalPeopleGroup(new QName(lpg));
        from.addNewLiteral().set((XmlObject)orgEntDoc);
        return from;
    }

    public LinksListType addReportLink(String id, String display, String objectClass) throws IOException {
        LinkType linkItem = this.linksList.addNewLink();
        linkItem.setId(id);
        linkItem.setDisplay(display);
        linkItem.setObjectClass(objectClass);
        return this.linksList;
    }

    public void setSubject(String subject) {
        this.manualTask.setSubject(subject);
    }

    public void addSubscription(SubscriptionEventState.Enum subscribed, SubscriptionEventType.Enum event) throws PipelineException {
        if (event.equals(SubscriptionEventType.COMPLETE_DEADLINE)) {
            this.manualTask.setNotifyNotCompleted(subscribed);
        } else if (event.equals(SubscriptionEventType.NOTIFY_ON_CREATION)) {
            this.manualTask.setNotifyOnCreation(subscribed);
        } else if (event.equals(SubscriptionEventType.START_DEADLINE)) {
            this.manualTask.setNotifyNotStarted(subscribed);
        } else if (event.equals(SubscriptionEventType.STATE_CHANGE_COMPLETED)) {
            this.manualTask.setStateChangeCompleted(subscribed);
        } else if (event.equals(SubscriptionEventType.STATE_CHANGE_CANCELLED)) {
            this.manualTask.setStateChangeCancelled(subscribed);
        } else if (event.equals(SubscriptionEventType.STATE_CHANGE_FAILED)) {
            this.manualTask.setStateChangeFailed(subscribed);
        } else if (event.equals(SubscriptionEventType.STATE_CHANGE_ON_HOLD)) {
            this.manualTask.setStateChangeSuspended(subscribed);
        } else if (event.equals(SubscriptionEventType.STATE_CHANGE_OWNER_CHANGED)) {
            this.manualTask.setStateChangeOwner(subscribed);
        } else if (event.equals(SubscriptionEventType.STATE_CHANGE_STARTED)) {
            this.manualTask.setStateChangeStarted(subscribed);
        } else if (event.equals(SubscriptionEventType.COMMENTS)) {
            this.manualTask.setComments(subscribed);
        }
    }
}

