/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.xpath;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.XMLParser;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.xpath.UsXpathFunction;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class Except
extends UsXpathFunction
implements Function {
    @Override
    public Object htsCall(Context context, List args) throws FunctionCallException {
        Element returnNode = null;
        IAbstractContext abContext = this.getAbstractContext(context);
        if (args.size() != 2 || args.get(0) == null || args.get(1) == null) {
            Locale locale = abContext != null ? abContext.getLocale() : Locale.getDefault();
            String message = I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_US_BAD_EXCEPT_ARGUMENTS, (Locale)locale);
            throw new FunctionCallException(message);
        }
        try {
            OrganizationalEntityDocument org1 = this.evaluateArgument(context, (Node)args.get(0));
            OrganizationalEntityDocument org2 = this.evaluateArgument(context, (Node)args.get(1));
            OrganizationalEntityDocument excepted = this.exceptOrgEntities(org1, org2);
            StringReader reader1 = new StringReader(excepted.toString());
            XMLParser parser = new XMLParser((Reader)reader1);
            org.w3c.dom.Document doc = parser.parse();
            DOMReader reader = new DOMReader();
            Document d = reader.read(doc);
            returnNode = d.getRootElement();
        }
        catch (Exception e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        return returnNode;
    }

    private OrganizationalEntityDocument exceptOrgEntities(OrganizationalEntityDocument org1, OrganizationalEntityDocument org2) {
        Set<Object> users1 = new HashSet();
        Set<Object> groups1 = new HashSet();
        if (org1 != null) {
            users1 = this.getUsers(org1.getOrganizationalEntity());
            groups1 = this.getGroups(org1.getOrganizationalEntity());
        }
        Set<Object> users2 = new HashSet();
        Set<Object> groups2 = new HashSet();
        if (org2 != null) {
            users2 = this.getUsers(org2.getOrganizationalEntity());
            groups2 = this.getGroups(org2.getOrganizationalEntity());
        }
        groups1.removeAll(groups2);
        users1.removeAll(users2);
        OrganizationalEntityDocument excepted = OrganizationalEntityDocument.Factory.newInstance();
        excepted.addNewOrganizationalEntity();
        if (groups1.size() > 0) {
            excepted.getOrganizationalEntity().addNewGroups();
            for (String string : groups1) {
                excepted.getOrganizationalEntity().getGroupsArray(0).addGroup(string);
            }
        } else {
            excepted.getOrganizationalEntity().addNewUsers();
            for (String string : users1) {
                excepted.getOrganizationalEntity().getUsersArray(0).addUser(string);
            }
        }
        return excepted;
    }

    private Set<String> getUsers(TOrganizationalEntity entity) {
        HashSet<String> set = new HashSet<String>();
        if (entity.sizeOfUsersArray() != 0 && entity.getUsersArray(0) != null) {
            for (int i = 0; i < entity.getUsersArray(0).sizeOfUserArray(); ++i) {
                set.add(entity.getUsersArray(0).getUserArray(i));
            }
        }
        return set;
    }

    private Set<String> getGroups(TOrganizationalEntity entity) {
        HashSet<String> set = new HashSet<String>();
        if (entity.sizeOfGroupsArray() != 0 && entity.getGroupsArray() != null) {
            for (int i = 0; i < entity.getGroupsArray(0).sizeOfGroupArray(); ++i) {
                set.add(entity.getGroupsArray(0).getGroupArray(i));
            }
        }
        return set;
    }
}

