/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.xpath;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPost;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.xpath.UsXpathFunction;
import java.net.URLDecoder;
import java.util.List;
import org.dom4j.tree.DefaultText;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class GetLastUserComment
extends UsXpathFunction
implements Function {
    @Override
    public Object htsCall(Context context, List args) throws FunctionCallException {
        DefaultText text = new DefaultText("");
        if (this.isMsgSecurityEnabled()) {
            return text;
        }
        try {
            String lastPost;
            HTSPost post;
            HTSTask task = this.getTaskFromContext(context);
            if (task != null && (post = task.getLastComment()) != null && (lastPost = URLDecoder.decode(post.getPagetext(), "UTF-8")) != null) {
                text = new DefaultText(lastPost);
            }
        }
        catch (Exception e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        return text;
    }

    public boolean isMsgSecurityEnabled() {
        boolean result = false;
        String msgSecurity = HTSServerProperties.getInstance().getProperty("msg.security.enabled");
        try {
            if (null != msgSecurity) {
                Boolean sec = new Boolean(msgSecurity);
                result = sec;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

