/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.xpath;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.util.dao.MessageUtils;
import com.ibm.cognos.internal.hts.xpath.UsXpathFunction;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class GetOutput
extends UsXpathFunction
implements Function {
    @Override
    public Object htsCall(Context context, List args) throws FunctionCallException {
        Element outputNode = null;
        try {
            String partName = null;
            if (args != null && args.size() > 0) {
                partName = (String)args.get(0);
            }
            HTSTask task = this.getTaskFromContext(context);
            HTSMessage outputMessage = null;
            if (task != null) {
                outputMessage = MessageUtils.getOutputMessage(task, partName);
            }
            if (outputMessage != null && outputMessage.getMessage() != null) {
                InputStream stream = IOUtils.toInputStream((String)outputMessage.getMessage());
                SAXReader reader = new SAXReader();
                reader.setMergeAdjacentText(true);
                Document doc = reader.read(stream);
                outputNode = doc.getRootElement();
            }
        }
        catch (DocumentException e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        catch (ClassCastException e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        return outputNode;
    }
}

