/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.xpath;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.XMLParser;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.util.dao.SubscriptionUtil;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TGroup;
import com.ibm.cognos.internal.hts.ws_ht.TGrouplist;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.TUser;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import com.ibm.cognos.internal.hts.xpath.UsXpathFunction;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class GetUnsubscriptions
extends UsXpathFunction
implements Function {
    @Override
    public Object htsCall(Context context, List args) throws FunctionCallException {
        Element returnNode = null;
        try {
            String subscriptionEvent = null;
            IAbstractContext abContext = this.getAbstractContext(context);
            if (args == null || args.size() <= 0) {
                Locale locale = abContext != null ? abContext.getLocale() : Locale.getDefault();
                String message = I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_US_BAD_EXCEPT_ARGUMENTS, (Locale)locale);
                throw new FunctionCallException(message);
            }
            subscriptionEvent = (String)args.get(0);
            HTSTask task = this.getTaskFromContext(context);
            String event_key = "SUBSCRIBE_" + subscriptionEvent;
            Collection<HTSTaskUser> unsubscriptionsByEvent = null;
            if (abContext != null && !abContext.getProperties().containsKey(event_key)) {
                unsubscriptionsByEvent = SubscriptionUtil.getUnSubscriptions(abContext, task, subscriptionEvent);
                abContext.getProperties().put(event_key, unsubscriptionsByEvent);
            } else if (abContext != null) {
                unsubscriptionsByEvent = (Collection<HTSTaskUser>)abContext.getProperties().get(event_key);
            }
            OrganizationalEntityDocument orgEntity = this.getOrgDoc(unsubscriptionsByEvent);
            StringReader reader1 = new StringReader(orgEntity.xmlText());
            XMLParser parser = new XMLParser((Reader)reader1);
            org.w3c.dom.Document doc = parser.parse();
            DOMReader reader = new DOMReader();
            Document d = reader.read(doc);
            returnNode = d.getRootElement();
        }
        catch (Exception e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        return returnNode;
    }

    private OrganizationalEntityDocument getOrgDoc(Collection<HTSTaskUser> unsubscribed) {
        OrganizationalEntityDocument orgDoc = OrganizationalEntityDocument.Factory.newInstance();
        TOrganizationalEntity org = orgDoc.addNewOrganizationalEntity();
        for (HTSTaskUser user : unsubscribed) {
            String token = user.getUserToken();
            if (user.isGroup()) {
                TGrouplist gList = this.getGroupList(org);
                TGroup tGroup = gList.addNewGroup();
                tGroup.setStringValue(token);
                continue;
            }
            TUserlist uList = this.getUserList(org);
            TUser tUser = uList.addNewUser();
            tUser.setStringValue(token);
        }
        return orgDoc;
    }

    protected TGrouplist getGroupList(TOrganizationalEntity org) {
        TGrouplist list;
        TGrouplist tGrouplist = list = org.sizeOfGroupsArray() != 0 ? org.getGroupsArray(0) : null;
        if (list == null) {
            list = org.addNewGroups();
        }
        return list;
    }

    protected TUserlist getUserList(TOrganizationalEntity org) {
        TUserlist list;
        TUserlist tUserlist = list = org.sizeOfUsersArray() != 0 ? org.getUsersArray(0) : null;
        if (list == null) {
            list = org.addNewUsers();
        }
        return list;
    }
}

