/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.xpath;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.XMLParser;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.ws_ht.TUser;
import com.ibm.cognos.internal.hts.xpath.UsXpathFunction;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.jaxen.Context;
import org.jaxen.FunctionCallException;

public abstract class GetUser
extends UsXpathFunction {
    protected HTSTask getTask(Context context, List args) throws FunctionCallException {
        String strTaskName = args != null && args.size() > 0 ? (String)args.get(0) : null;
        HTSTask task = null;
        task = strTaskName != null ? this.getTaskByName(strTaskName) : this.getTaskFromContext(context);
        return task;
    }

    protected Element makeNode(XmlObject user) throws Exception {
        StringReader reader1 = new StringReader(user.xmlText());
        XMLParser parser = new XMLParser((Reader)reader1);
        org.w3c.dom.Document doc = parser.parse();
        DOMReader reader = new DOMReader();
        Document d = reader.read(doc);
        return d.getRootElement();
    }

    protected String getUserNameString(Context context, HTSTaskUser user, HTSTaskUser taskCreator) throws FunctionCallException {
        String displayName = null;
        try {
            IAbstractContext abstractContext = this.getAbstractContext(context);
            BiBusHeader biBusHeader = null;
            if (abstractContext != null) {
                biBusHeader = abstractContext.getHeader().getBiBusHeader();
            }
            displayName = user == null ? "" : this.getDisplayName(abstractContext, user, taskCreator);
        }
        catch (Exception e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        return displayName;
    }

    protected Element getUserName(Context context, HTSTaskUser user, HTSTaskUser taskCreator) throws FunctionCallException {
        Element returnNode = null;
        try {
            String displayName = this.getUserNameString(context, user, taskCreator);
            TUser dispUser = TUser.Factory.newInstance();
            dispUser.setStringValue(displayName);
            returnNode = this.makeNode((XmlObject)dispUser);
        }
        catch (FunctionCallException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        return returnNode;
    }

    private String getDisplayName(IAbstractContext context, HTSTaskUser user, HTSTaskUser creator) throws HumanTaskServiceException {
        String displayName = null;
        displayName = context.getHeader() == null || context.getHeader().getBiBusHeader() == null ? this.getDisplayNameLogon(context, user, creator) : UserUtils.instance().getUserName(context, user);
        if (displayName == null || "".equals(displayName)) {
            Locale locale = LocaleUtil.getRequestProductLocale((BiBusHeader)context.getHeader().getBiBusHeader());
            I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_USV_UNKNOWN_OWNER, (Locale)locale);
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDisplayNameLogon(IAbstractContext context, HTSTaskUser user, HTSTaskUser creator) throws HumanTaskServiceException {
        BiBusHeader header = null;
        String displayName = null;
        try {
            context.logon(creator);
            header = context.getHeader().getBiBusHeader();
            displayName = UserUtils.instance().getUserName(context, user);
        }
        finally {
            if (header != null) {
                UserUtils.instance().logoff(header);
            }
        }
        return displayName;
    }
}

