/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.xpath;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.XMLParser;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TGrouplist;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import com.ibm.cognos.internal.hts.xpath.GetRole;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class GroupExpand
extends GetRole
implements Function {
    @Override
    public Object htsCall(Context context, List args) throws FunctionCallException {
        Element returnNode = null;
        IAbstractContext abContext = this.getAbstractContext(context);
        if (args.size() != 1 || args.get(0) == null) {
            Locale locale = abContext != null ? abContext.getLocale() : Locale.getDefault();
            String message = I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_US_BAD_CAMEXPAND_ARGUMENTS, (Locale)locale);
            throw new FunctionCallException(message);
        }
        try {
            OrganizationalEntityDocument groupedEntity = this.evaluateArgument(context, (Node)args.get(0));
            OrganizationalEntityDocument expandedEntity = this.expandGroups(context, abContext, groupedEntity);
            StringReader reader1 = new StringReader(expandedEntity.xmlText());
            XMLParser parser = new XMLParser((Reader)reader1);
            org.w3c.dom.Document doc = parser.parse();
            DOMReader reader = new DOMReader();
            Document d = reader.read(doc);
            returnNode = d.getRootElement();
        }
        catch (Exception e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        return returnNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrganizationalEntityDocument expandGroups(Context context, IAbstractContext abContext, OrganizationalEntityDocument groupedEntity) throws HumanTaskServiceException {
        OrganizationalEntityDocument orgEntity = OrganizationalEntityDocument.Factory.newInstance();
        orgEntity.addNewOrganizationalEntity().addNewUsers();
        if (groupedEntity.getOrganizationalEntity() != null && groupedEntity.getOrganizationalEntity().sizeOfGroupsArray() != 0) {
            TGrouplist groups = groupedEntity.getOrganizationalEntity().getGroupsArray(0);
            for (int i = 0; groups != null && i < groups.sizeOfGroupArray(); ++i) {
                String group = groups.getGroupArray(i);
                HTSTaskUser usGroup = UserUtils.instance().findUser(group);
                if (!usGroup.isGroup()) {
                    Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, new Object[0]);
                }
                BiBusHeader biBusHeader = abContext.getHeader().getBiBusHeader();
                try {
                    if (biBusHeader == null) {
                        HTSTask task = this.getTaskFromContext(context);
                        biBusHeader = UserUtils.instance().logon(task.getCreatedBy());
                    }
                    Set<String> users = UserUtils.instance().expandGroup(abContext, usGroup);
                    this.addUsersToOrgEntity(users, orgEntity.getOrganizationalEntity().getUsersArray(0));
                    continue;
                }
                catch (Exception e) {
                    Utils.throwHumanTaskServiceException(e);
                    continue;
                }
                finally {
                    if (abContext.getHeader().getBiBusHeader() == null && biBusHeader != null) {
                        UserUtils.instance().logoff(biBusHeader);
                    }
                }
            }
        } else {
            orgEntity = groupedEntity;
        }
        return orgEntity;
    }

    private void addUsersToOrgEntity(Set<String> users, TUserlist userList) {
        if (userList != null) {
            for (String user : users) {
                userList.addNewUser().setStringValue(user);
            }
        }
    }
}

