/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.xpath;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.ibm.cognos.internal.hts.apiHandlers.context.ChangedHumanRoleMode;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.xpath.UsXpathFunction;
import java.util.List;
import java.util.Locale;
import org.dom4j.tree.DefaultText;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;

public class HasChangedRoles
extends UsXpathFunction
implements Function {
    @Override
    public Object htsCall(Context context, List args) throws FunctionCallException {
        String rolesChanged = Boolean.FALSE.toString();
        try {
            ChangedHumanRoleMode mode = ChangedHumanRoleMode.CHANGED_ROLE_TYPE_ADDED;
            IAbstractContext htsContext = super.getAbstractContext(context);
            String modeString = "";
            String roleString = "";
            if (args != null && args.size() == 1 && (modeString = (String)args.get(0)) != null) {
                mode = ChangedHumanRoleMode.valueOf(modeString);
            }
            if (args.size() != 1 || mode == null) {
                Locale locale = htsContext != null ? htsContext.getLocale() : Locale.getDefault();
                String message = I18NUtil.getMessage((I18NCode)UsI18NCode.MSG_US_INVALID_PARAMETER, (Object[])new Object[]{"?", "getChangedRoles", modeString + "," + roleString}, (Locale)locale);
                throw new FunctionCallException(message);
            }
            Boolean changed = htsContext.getChangedHumanRoles(mode, null).size() > 0;
            if (changed != null) {
                rolesChanged = changed.toString();
            }
        }
        catch (ClassCastException e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        catch (Throwable e) {
            throw new FunctionCallException(e.getLocalizedMessage());
        }
        DefaultText tRoleChanged = new DefaultText(rolesChanged);
        return tRoleChanged;
    }
}

