/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.xpath;

import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.TUser;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import com.ibm.cognos.internal.hts.xpath.XPathVariableContext;
import java.util.List;
import org.dom4j.Node;
import org.jaxen.Context;
import org.jaxen.FunctionCallException;
import org.jaxen.UnresolvableException;

public abstract class UsXpathFunction {
    protected abstract Object htsCall(Context var1, List var2) throws FunctionCallException;

    public Object call(Context context, List args) throws FunctionCallException {
        IAbstractContext abContext = this.getAbstractContext(context);
        String timingName = this.getClass().getSimpleName();
        Object returnObject = this.htsCall(context, args);
        return returnObject;
    }

    protected Object getVariableValue(Context context, XPathVariableContext.XPathVariable xpathVar) {
        Object val = null;
        try {
            val = context.getVariableValue(xpathVar.namespace(), "", xpathVar.key());
        }
        catch (UnresolvableException unresolvableException) {
            // empty catch block
        }
        return val;
    }

    protected HTSTask getTaskFromContext(Context context) throws FunctionCallException {
        Object abstractContextObject = null;
        Object taskObject = null;
        Object taskIdObject = null;
        abstractContextObject = this.getVariableValue(context, XPathVariableContext.XPathVariable.CONTEXT);
        taskObject = this.getVariableValue(context, XPathVariableContext.XPathVariable.TASK);
        taskIdObject = this.getVariableValue(context, XPathVariableContext.XPathVariable.TASK_ID);
        HTSTask task = null;
        if (abstractContextObject != null && task == null) {
            task = ((IAbstractContext)abstractContextObject).getPersistedTask();
        }
        if (taskObject != null && task == null) {
            task = (HTSTask)taskObject;
        }
        if (taskIdObject != null && task == null) {
            String taskIdString = (String)taskIdObject;
            task = (HTSTask)DAOFactory.getFactory().buildTaskDAO().getById(taskIdString);
        }
        return task;
    }

    protected IAbstractContext getAbstractContext(Context context) throws FunctionCallException {
        IAbstractContext abContext = null;
        Object abstractContextObject = null;
        try {
            abstractContextObject = context.getVariableValue("", "", XPathVariableContext.XPathVariable.CONTEXT.key());
        }
        catch (UnresolvableException unresolvableException) {
            // empty catch block
        }
        if (abstractContextObject != null) {
            abContext = (IAbstractContext)abstractContextObject;
        }
        return abContext;
    }

    protected HTSTask getTaskByName(String strTaskName) {
        HTSTask task = null;
        List<HTSTask> usTaskList = DAOFactory.getFactory().buildTaskDAO().findByName(strTaskName);
        if (usTaskList != null && usTaskList.size() > 0) {
            task = usTaskList.get(0);
        }
        return task;
    }

    protected OrganizationalEntityDocument evaluateArgument(Context context, Node argument) {
        OrganizationalEntityDocument orgDoc = null;
        orgDoc = this.evaluateEmptyArgument(argument);
        if (orgDoc != null) {
            return orgDoc;
        }
        try {
            if (argument.getName().equals("organizationalEntity")) {
                orgDoc = OrganizationalEntityDocument.Factory.parse((String)argument.asXML());
            } else {
                TUser user = TUser.Factory.parse((String)argument.asXML());
                orgDoc = OrganizationalEntityDocument.Factory.newInstance();
                TOrganizationalEntity org = orgDoc.addNewOrganizationalEntity();
                TUserlist list = org.addNewUsers();
                if (!"".equals(user.getStringValue())) {
                    TUser listUser = list.addNewUser();
                    listUser.setStringValue(user.getStringValue());
                }
            }
        }
        catch (Throwable e) {
            orgDoc = OrganizationalEntityDocument.Factory.newInstance();
            orgDoc.addNewOrganizationalEntity();
        }
        return orgDoc;
    }

    private OrganizationalEntityDocument evaluateEmptyArgument(Node argument) {
        OrganizationalEntityDocument org = null;
        if (argument == null) {
            org = OrganizationalEntityDocument.Factory.newInstance();
            org.addNewOrganizationalEntity();
        }
        return org;
    }
}

