/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.xpath;

import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.xpath.Except;
import com.ibm.cognos.internal.hts.xpath.GetActualOwner;
import com.ibm.cognos.internal.hts.xpath.GetActualOwnerDisplayName;
import com.ibm.cognos.internal.hts.xpath.GetBusinessAdministrators;
import com.ibm.cognos.internal.hts.xpath.GetChangedRoles;
import com.ibm.cognos.internal.hts.xpath.GetCurrentUser;
import com.ibm.cognos.internal.hts.xpath.GetCurrentUserDisplayName;
import com.ibm.cognos.internal.hts.xpath.GetInput;
import com.ibm.cognos.internal.hts.xpath.GetLastUserComment;
import com.ibm.cognos.internal.hts.xpath.GetLastUserCommentTitle;
import com.ibm.cognos.internal.hts.xpath.GetNotitifcationRecipients;
import com.ibm.cognos.internal.hts.xpath.GetOperation;
import com.ibm.cognos.internal.hts.xpath.GetOutput;
import com.ibm.cognos.internal.hts.xpath.GetPotentialOwners;
import com.ibm.cognos.internal.hts.xpath.GetStakeholders;
import com.ibm.cognos.internal.hts.xpath.GetStakeholdersDisplayNames;
import com.ibm.cognos.internal.hts.xpath.GetStatus;
import com.ibm.cognos.internal.hts.xpath.GetTaskInitiator;
import com.ibm.cognos.internal.hts.xpath.GetTaskInitiatorDisplayName;
import com.ibm.cognos.internal.hts.xpath.GetTaskReadByUsers;
import com.ibm.cognos.internal.hts.xpath.GetTaskUrl;
import com.ibm.cognos.internal.hts.xpath.GetUnsubscriptions;
import com.ibm.cognos.internal.hts.xpath.GroupExpand;
import com.ibm.cognos.internal.hts.xpath.HasChangedRoles;
import com.ibm.cognos.internal.hts.xpath.HasOwnerChanged;
import com.ibm.cognos.internal.hts.xpath.Translate;
import com.ibm.cognos.internal.hts.xpath.Union;
import com.ibm.cognos.internal.hts.xpath.XPathVariableContext;
import java.util.List;
import org.dom4j.Node;
import org.jaxen.Function;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleFunctionContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom4j.Dom4jXPath;

public class XPathEvaluator {
    private static final String EXAMPLE_NAMESPACE = "http://www.example.org/WS-HT";
    private static final String MANUALTASK_NAMESPACE = "http://wsdl.manualTaskService.developer.cognos.com";
    private SimpleFunctionContext m_functionContext;
    private SimpleVariableContext m_variableContext;

    public XPathEvaluator(XPathVariableContext variableContext) {
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.addNamespace("ht", EXAMPLE_NAMESPACE);
        this.initialize(variableContext, (NamespaceContext)namespaceContext);
    }

    public XPathEvaluator(XPathVariableContext variableContext, NamespaceContext namespaceContext) {
        this.initialize(variableContext, namespaceContext);
    }

    private void initialize(XPathVariableContext variableContext, NamespaceContext namespaceContext) {
        this.m_variableContext = variableContext.getSimpleVariableContext();
        this.m_functionContext = new XPathFunctionContext(true);
        this.m_functionContext.registerFunction("", "getInput", (Function)new GetInput());
        this.m_functionContext.registerFunction("", "getOutput", (Function)new GetOutput());
        this.m_functionContext.registerFunction("", "getStatus", (Function)new GetStatus());
        this.m_functionContext.registerFunction("", "getPotentialOwners", (Function)new GetPotentialOwners());
        this.m_functionContext.registerFunction("", "getNotificationRecipients", (Function)new GetNotitifcationRecipients());
        this.m_functionContext.registerFunction("", "getActualOwner", (Function)new GetActualOwner());
        this.m_functionContext.registerFunction("", "getCurrentUser", (Function)new GetCurrentUser());
        this.m_functionContext.registerFunction("", "getCurrentUserDisplayName", (Function)new GetCurrentUserDisplayName());
        this.m_functionContext.registerFunction("", "getTaskStakeholders", (Function)new GetStakeholders());
        this.m_functionContext.registerFunction("", "getBusinessAdministrators", (Function)new GetBusinessAdministrators());
        this.m_functionContext.registerFunction("", "getOperation", (Function)new GetOperation());
        this.m_functionContext.registerFunction("", "hasOwnerChanged", (Function)new HasOwnerChanged());
        this.m_functionContext.registerFunction("", "union", (Function)new Union());
        this.m_functionContext.registerFunction("", "expand", (Function)new GroupExpand());
        this.m_functionContext.registerFunction("", "except", (Function)new Except());
        this.m_functionContext.registerFunction("", "getTaskInitiator", (Function)new GetTaskInitiator());
        this.m_functionContext.registerFunction("", "getUnsubscriptions", (Function)new GetUnsubscriptions());
        this.m_functionContext.registerFunction("", "getTaskUrl", (Function)new GetTaskUrl());
        this.m_functionContext.registerFunction("", "getLastUserComment", (Function)new GetLastUserComment());
        this.m_functionContext.registerFunction("", "getLastUserCommentTitle", (Function)new GetLastUserCommentTitle());
        this.m_functionContext.registerFunction("", "getActualOwnerDisplayName", (Function)new GetActualOwnerDisplayName());
        this.m_functionContext.registerFunction("", "getTaskInitiatorDisplayName", (Function)new GetTaskInitiatorDisplayName());
        this.m_functionContext.registerFunction("", "getStakeholdersDisplayNames", (Function)new GetStakeholdersDisplayNames());
        this.m_functionContext.registerFunction("", "getTaskReadByUsers", (Function)new GetTaskReadByUsers());
        this.m_functionContext.registerFunction("", "translate", (Function)new Translate());
        this.m_functionContext.registerFunction("", "getChangedRoles", (Function)new GetChangedRoles());
        this.m_functionContext.registerFunction("", "hasChangedRoles", (Function)new HasChangedRoles());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getInput", (Function)new GetInput());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getOutput", (Function)new GetOutput());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getStatus", (Function)new GetStatus());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getPotentialOwners", (Function)new GetPotentialOwners());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getNotificationRecipients", (Function)new GetNotitifcationRecipients());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getActualOwner", (Function)new GetActualOwner());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getTaskStakeholders", (Function)new GetStakeholders());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getBusinessAdministrators", (Function)new GetBusinessAdministrators());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "union", (Function)new Union());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "except", (Function)new Except());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getTaskInitiator", (Function)new GetTaskInitiator());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getUnsubscriptions", (Function)new GetUnsubscriptions());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getTaskUrl", (Function)new GetTaskUrl());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getLastUserComment", (Function)new GetLastUserComment());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getLastUserCommentTitle", (Function)new GetLastUserCommentTitle());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getActualOwnerDisplayName", (Function)new GetActualOwnerDisplayName());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getTaskInitiatorDisplayName", (Function)new GetTaskInitiatorDisplayName());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getStakeholdersDisplayNames", (Function)new GetStakeholdersDisplayNames());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getOperation", (Function)new GetOperation());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "expand", (Function)new GroupExpand());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "hasOwnerChanged", (Function)new HasOwnerChanged());
        this.m_functionContext.registerFunction(EXAMPLE_NAMESPACE, "getTaskReadByUsers", (Function)new GetTaskReadByUsers());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "translate", (Function)new Translate());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getCurrentUser", (Function)new GetCurrentUser());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getCurrentUserDisplayName", (Function)new GetCurrentUserDisplayName());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "getChangedRoles", (Function)new GetChangedRoles());
        this.m_functionContext.registerFunction(MANUALTASK_NAMESPACE, "hasChangedRoles", (Function)new HasChangedRoles());
    }

    public Object selectNode(String xpathString) throws HumanTaskServiceException {
        Object node = null;
        try {
            Dom4jXPath xpath = new Dom4jXPath(xpathString);
            xpath.setFunctionContext((FunctionContext)this.m_functionContext);
            xpath.setVariableContext((VariableContext)this.m_variableContext);
            node = xpath.selectSingleNode(null);
        }
        catch (JaxenException e) {
            Utils.throwHumanTaskServiceException(e);
        }
        return node;
    }

    public List selectNodes(String xpathString) throws HumanTaskServiceException {
        List nodes = null;
        try {
            Dom4jXPath xpath = new Dom4jXPath(xpathString);
            xpath.setFunctionContext((FunctionContext)this.m_functionContext);
            xpath.setVariableContext((VariableContext)this.m_variableContext);
            nodes = xpath.selectNodes(null);
        }
        catch (JaxenException e) {
            Utils.throwHumanTaskServiceException(e);
        }
        return nodes;
    }

    public String selectNodeValue(String expr) throws HumanTaskServiceException {
        StringBuffer buf = new StringBuffer();
        Node selectedNode = (Node)this.selectNode(expr);
        if (selectedNode != null) {
            List children = selectedNode.selectNodes("*");
            if (children.isEmpty()) {
                buf.append(selectedNode.getStringValue());
            } else {
                children = selectedNode.selectNodes("*");
                for (Node child : children) {
                    buf.append(child.asXML());
                }
            }
        }
        return buf.toString();
    }
}

