<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:impl="http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1" xmlns:hta="http://www.example.org/WS-HT/api" xmlns:ht="http://www.example.org/WS-HT" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:import href="rpc-common.xsl"/>
	<xsl:output method="xml" version="1.0"/>
	<xsl:template match="/">
		<xsl:apply-templates select="//*[local-name()='createAcknowledgeManualTaskRPC']"/>
	</xsl:template>
	<xsl:template match="//*[local-name()='createAcknowledgeManualTaskRPC']">
		<impl:createAcknowledgeManualTask xmlns:impl="http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1" xmlns:hta="http://www.example.org/WS-HT/api" xmlns:ht="http://www.example.org/WS-HT" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://wsdl.manualTaskService.developer.cognos.com">
			<impl:beplNotification name="{./*[local-name()='CogBeplNotification_name']}">
				<xsl:if test="./*[local-name()='CogBeplNotification_priority'] and ./*[local-name()='CogBeplNotification_priority']!='' ">
					<impl:priority>
						<xsl:value-of select="./*[local-name()='CogBeplNotification_priority']"/>
					</impl:priority>
				</xsl:if>
				<impl:peopleAssignments>
                    <xsl:if test="./*[local-name()='CogBeplNotification_peopleAssignments_recipients']!='' or  ./*[local-name()='CogBeplNotification_peopleAssignments_recipientGroups'] != '' ">
                        <ht:recipients>
                            <xsl:call-template name="decodeUsersAndGroups">
                                <xsl:with-param name="userList">
                                    <xsl:value-of select="./*[local-name()='CogBeplNotification_peopleAssignments_recipients']"/>
                                </xsl:with-param>
                                <xsl:with-param name="groupList">
                                    <xsl:value-of select="./*[local-name()='CogBeplNotification_peopleAssignments_recipientGroups']"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </ht:recipients>
					</xsl:if>
					<xsl:if test="./*[local-name()='CogBeplNotification_peopleAssignments_taskStakeholders'] != ''">
                        <ht:taskStakeholders>
                            <xsl:call-template name="decodeUsersAndGroups">
                                <xsl:with-param name="userList">
                                    <xsl:value-of select="./*[local-name()='CogBeplNotification_peopleAssignments_taskStakeholders']"/>
                                </xsl:with-param>							
                            </xsl:call-template>						
                        </ht:taskStakeholders>
					</xsl:if>
				</impl:peopleAssignments>
				<xsl:if test="./*[local-name()='CogBeplNotification_presentationElements_name'] and ./*[local-name()='CogBeplNotification_presentationElements_name']!='' ">
				    <impl:presentationElements>
					    <ht:name xml:lang="en-us">
						    <xsl:value-of select="./*[local-name()='CogBeplNotification_presentationElements_name']"/>
					    </ht:name>
					    <ht:subject xml:lang="en-us">
						    <xsl:value-of select="./*[local-name()='CogBeplNotification_presentationElements_subject']"/>
					    </ht:subject>
					    <ht:description xml:lang="en-us" contentType="text/plain">
						    <xsl:value-of select="./*[local-name()='CogBeplNotification_presentationElements_description']"/>
					    </ht:description>
				    </impl:presentationElements>
				</xsl:if>
				<xsl:if test="./*[local-name()='CogBeplNotification_attachment_value'] and ./*[local-name()='CogBeplNotification_attachment_value']!='' ">
					<impl:attachment>
						<hta:attachmentInfo>
							<hta:name>
								<xsl:value-of select="./*[local-name()='CogBeplNotification_attachment_attachmentInfo_name']"/>
							</hta:name>
							<hta:accessType>
								<xsl:value-of select="./*[local-name()='CogBeplNotification_attachment_attachmentInfo_accessType']"/>
							</hta:accessType>
							<hta:contentType>
								<xsl:value-of select="./*[local-name()='CogBeplNotification_attachment_attachmentInfo_contentType']"/>
							</hta:contentType>
							<hta:attachedAt>
								<xsl:value-of select="./*[local-name()='CogBeplNotification_attachment_attachmentInfo_attachedAt']"/>
							</hta:attachedAt>
							<hta:attachedBy>
								<xsl:value-of select="./*[local-name()='CogBeplNotification_attachment_attachmentInfo_attachedBy']"/>
							</hta:attachedBy>
						</hta:attachmentInfo>
						<hta:value>
							<xsl:value-of select="./*[local-name()='CogBeplNotification_attachment_value']"/>
						</hta:value>
					</impl:attachment>
				</xsl:if>
			</impl:beplNotification>
			<impl:manualTask>
				<impl:preview>
					<xsl:copy-of select="//*[local-name()='tsePreview']"/>
				</impl:preview>
				<impl:taskIconPath>
                    <xsl:value-of select="./*[local-name()='CogManualTask_taskIconPath']"/>				
				</impl:taskIconPath>
				<impl:subject>
                    <xsl:value-of select="./*[local-name()='CogManualTask_subject']"/>				
				</impl:subject>
				<impl:description>
                    <xsl:value-of select="./*[local-name()='CogManualTask_description']"/>
				</impl:description>
				<impl:acknowledgeText>
					<xsl:value-of select="./*[local-name()='CogManualTask_acknowledgeText']"/>
				</impl:acknowledgeText>
				<xsl:if test="./*[local-name()='CogManualTask_taskLinksList'] and ./*[local-name()='CogManualTask_taskLinksList'] != '' ">
					<impl:taskLinksList>
						<xsl:call-template name="decodeLinksList">
							<xsl:with-param name="linksList">
								<xsl:value-of select="./*[local-name()='CogManualTask_taskLinksList']"/>
							</xsl:with-param>
						</xsl:call-template>
					</impl:taskLinksList>
				</xsl:if>
				<impl:parentEventId>
					<xsl:value-of select="//*[local-name()='parentEventId']"/>
				</impl:parentEventId>
			</impl:manualTask>
		</impl:createAcknowledgeManualTask>
	</xsl:template>
</xsl:stylesheet>
