<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:impl="http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1" xmlns:hta="http://www.example.org/WS-HT/api" xmlns:ht="http://www.example.org/WS-HT" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:import href="rpc-common.xsl"/>
	<xsl:output method="xml" version="1.0"/>
	<xsl:template match="/">
		<xsl:apply-templates select="//*[local-name()='createAgentUserTaskRPC']"/>
	</xsl:template>
	<xsl:template match="//*[local-name()='createAgentUserTaskRPC']">
		<impl:createAgentUserTask xmlns:impl="http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1" xmlns:hta="http://www.example.org/WS-HT/api" xmlns:ht="http://www.example.org/WS-HT" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://wsdl.manualTaskService.developer.cognos.com">
            <xsl:call-template name="buildCogBeplTask"/>
			<impl:manualTask>
				<impl:preview>
					<xsl:copy-of select="//*[local-name()='tsePreview']"/>
				</impl:preview>
				<impl:eventId>
					<xsl:value-of select="//*[local-name()='eventId']"/>
				</impl:eventId>
				<impl:parentEventId>
					<xsl:value-of select="//*[local-name()='parentEventId']"/>
				</impl:parentEventId>
				<impl:taskIconPath>
                    <xsl:value-of select="./*[local-name()='CogManualTask_taskIconPath']"/>				
				</impl:taskIconPath>
				<impl:subject>
                    <xsl:value-of select="./*[local-name()='CogManualTask_subject']"/>				
				</impl:subject>
				<impl:description>
                    <xsl:value-of select="./*[local-name()='CogManualTask_description']"/>
				</impl:description>
				<xsl:if test="./*[local-name()='CogManualTask_taskLinksList'] and ./*[local-name()='CogManualTask_taskLinksList'] != '' ">
					<impl:taskLinksList>
						<xsl:call-template name="decodeLinksList">
							<xsl:with-param name="linksList">
								<xsl:value-of select="./*[local-name()='CogManualTask_taskLinksList']"/>
							</xsl:with-param>
						</xsl:call-template>
					</impl:taskLinksList>
				</xsl:if>
				<xsl:if test="./*[local-name()='CogManualTask_submitText'] and ./*[local-name()='CogManualTask_submitText']!='' ">
					<impl:submitText>
						<xsl:value-of select="./*[local-name()='CogManualTask_submitText']"/>
					</impl:submitText>
				</xsl:if>
				<xsl:call-template name="processDeadlines">
                    <xsl:with-param name="deadlines" select="./*[local-name()='CogManualTask_deadlines']"/>
                </xsl:call-template>                
                <xsl:call-template name="emailNotification"/>
			</impl:manualTask>
		</impl:createAgentUserTask>
	</xsl:template>
</xsl:stylesheet>
