<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:impl="http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1" xmlns:hta="http://www.example.org/WS-HT/api" xmlns:ht="http://www.example.org/WS-HT" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="xml" version="1.0"/>
	<xsl:template name="buildCogBeplTask">
				<impl:beplTask name="{./*[local-name()='CogBeplTask_name']}">
				<xsl:if test="./*[local-name()='CogBeplTask_priority'] and ./*[local-name()='CogBeplTask_priority']!='' ">
					<impl:priority>
						<xsl:value-of select="./*[local-name()='CogBeplTask_priority']"/>
					</impl:priority>
				</xsl:if>
				<xsl:if test="./*[local-name()='CogBeplTask_activationTime'] and ./*[local-name()='CogBeplTask_activationTime']!='' ">
					<impl:activationTime>
						<xsl:value-of select="./*[local-name()='CogBeplTask_activationTime']"/>
					</impl:activationTime>
				</xsl:if>
				<xsl:if test="./*[local-name()='CogBeplTask_expirationTime'] and ./*[local-name()='CogBeplTask_expirationTime']!='' ">
					<impl:expirationTime>
						<xsl:value-of select="./*[local-name()='CogBeplTask_expirationTime']"/>
					</impl:expirationTime>
				</xsl:if>
				<impl:peopleAssignments>
					<ht:potentialOwners>
                        <xsl:if test="./*[local-name()='CogBeplTask_peopleAssignments_potentialOwners']!='' or  ./*[local-name()='CogBeplTask_peopleAssignments_potentialOwnerGroups'] != '' ">
                            <xsl:call-template name="decodeUsersAndGroups">
                                <xsl:with-param name="userList">
                                    <xsl:value-of select="./*[local-name()='CogBeplTask_peopleAssignments_potentialOwners']"/>
                                </xsl:with-param>
                                <xsl:with-param name="groupList">
                                    <xsl:value-of select="./*[local-name()='CogBeplTask_peopleAssignments_potentialOwnerGroups']"/>
                                </xsl:with-param>
                            </xsl:call-template>
                        </xsl:if>
					</ht:potentialOwners>
					<ht:taskStakeholders>
                        <xsl:if test="./*[local-name()='CogBeplTask_peopleAssignments_taskStakeholders']!='' ">
                            <xsl:call-template name="decodeUsersAndGroups">
                                <xsl:with-param name="userList">
                                    <xsl:value-of select="./*[local-name()='CogBeplTask_peopleAssignments_taskStakeholders']"/>
                                </xsl:with-param>							
                            </xsl:call-template>
						</xsl:if>
					</ht:taskStakeholders>
					<ht:businessAdministrators>
				    	<xsl:call-template name="decodeUsersAndGroups">
                        	<xsl:with-param name="groupList">
                            	<xsl:text>CAMID(":Server Administrators")</xsl:text>
                        	</xsl:with-param>							
                       </xsl:call-template>
					</ht:businessAdministrators>
				</impl:peopleAssignments>
				<xsl:if test="./*[local-name()='CogBeplTask_attachment_value'] and ./*[local-name()='CogBeplTask_attachment_value']!='' ">
					<impl:attachment>
						<hta:attachmentInfo>
							<hta:name>
								<xsl:value-of select="./*[local-name()='CogBeplTask_attachment_attachmentInfo_name']"/>
							</hta:name>
							<hta:accessType>
								<xsl:value-of select="./*[local-name()='CogBeplTask_attachment_attachmentInfo_accessType']"/>
							</hta:accessType>
							<hta:contentType>
								<xsl:value-of select="./*[local-name()='CogBeplTask_attachment_attachmentInfo_contentType']"/>
							</hta:contentType>
							<hta:attachedAt>
								<xsl:value-of select="./*[local-name()='CogBeplTask_attachment_attachmentInfo_attachedAt']"/>
							</hta:attachedAt>
							<hta:attachedBy>
								<xsl:value-of select="./*[local-name()='CogBeplTask_attachment_attachmentInfo_attachedBy']"/>
							</hta:attachedBy>
						</hta:attachmentInfo>
						<hta:value>
							<xsl:value-of select="./*[local-name()='CogBeplTask_attachment_value']"/>
						</hta:value>
					</impl:attachment>
				</xsl:if>
			</impl:beplTask>
	</xsl:template>
	
	<!-- decode the task list string which consists of  [id1|taskName1]:displayname1;[id2|taskName2]:displayname2;[idN|taskNameN]:displaynameN... -->
	<xsl:template name="decodeLinksList">
		<xsl:param name="linksList"/>
		<xsl:choose>
			<xsl:when test="contains($linksList, ';')">
				<xsl:variable name="before" select="substring-before($linksList,';')"/>
				<xsl:variable name="after" select="substring-after($linksList,';')"/>
				<xsl:if test="$before != '' ">
					<xsl:call-template name="decodeLinksListItem">
						<xsl:with-param name="item">
							<xsl:value-of select="$before"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="$after != '' ">
					<xsl:call-template name="decodeLinksList">
						<xsl:with-param name="linksList">
							<xsl:value-of select="$after"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$linksList != '' ">
					<xsl:call-template name="decodeLinksListItem">
						<xsl:with-param name="item">
							<xsl:value-of select="$linksList"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--id:name -->
	<xsl:template name="decodeLinksListItem">
		<xsl:param name="item"/>
		<impl:taskLink>
			<xsl:choose>
				<xsl:when test="contains($item, ':')">
					<impl:display>
						<xsl:value-of select="substring-after($item,':')"/>
					</impl:display>
					<impl:id>
						<xsl:value-of select="substring-before($item,':')"/>
					</impl:id>
				</xsl:when>
				<xsl:otherwise>
					<impl:display>
						<xsl:value-of select="$item"/>
					</impl:display>
					<impl:id>
						<xsl:value-of select="$item"/>
					</impl:id>
				</xsl:otherwise>
			</xsl:choose>
		</impl:taskLink>
	</xsl:template>
	<xsl:template name="decodeUsersAndGroups">
		<xsl:param name="userList"/>
		<xsl:param name="groupList"/>
		<ht:from logicalPeopleGroup="CAM">
			<ht:literal>
				<ht:organizationalEntity>							
					<xsl:choose>
						<xsl:when test="$userList != '' ">
							<ht:users>
								<xsl:call-template name="decodeUsers">
									<xsl:with-param name="list">
										<xsl:value-of select="$userList"/>
									</xsl:with-param>
								</xsl:call-template>
							</ht:users>
						</xsl:when>
						<xsl:when test="$groupList != ''">
							<ht:groups>
								<xsl:call-template name="decodeUsers">
									<xsl:with-param name="list">
										<xsl:value-of select="$groupList"/>										
									</xsl:with-param>
									<xsl:with-param name="type">ht:group</xsl:with-param>
								</xsl:call-template>
							</ht:groups>
						</xsl:when>
					</xsl:choose>
				</ht:organizationalEntity>
			</ht:literal>
		</ht:from>
	</xsl:template>
	
	<!-- decode the task list string which consists of  
            u1;u2;u3 -->
	<xsl:template name="decodeUsers">
		<xsl:param name="list"/>
		<xsl:param name="type">ht:user</xsl:param>
		<xsl:choose>
			<xsl:when test="contains($list, ';')">
				<xsl:variable name="before" select="substring-before($list,';')"/>
				<xsl:variable name="after" select="substring-after($list,';')"/>
				<xsl:if test="$before != '' ">
					<xsl:element name="{$type}">
						<xsl:value-of select="$before"/>
					</xsl:element>
				</xsl:if>
				<xsl:if test="$after != '' ">
					<xsl:call-template name="decodeUsers">
						<xsl:with-param name="list">
							<xsl:value-of select="$after"/>
						</xsl:with-param>
						<xsl:with-param name="type">
                            <xsl:value-of select="$type"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$list != '' ">
					<xsl:element name="{$type}">
						<xsl:value-of select="$list"/>
					</xsl:element>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--  deal with the deadlines -->
	<!-- the syntax is 
	    <start|complete>:<until|for>:<xs:dateTime|xs:duration>  
	    e.g. start:for:P7DT12H   (start for 7 days 12 hours).
	    e.g. complete:until:2009-12-25T09:30:00.0Z  (complete by date 25 Dec 2009, 09:30:00 UTC).
	    use ; (semi-colon) to delimit multiple entries.
    -->
	<xsl:template name="processDeadlines">
        <xsl:param name="deadlines"/>
        <xsl:choose>
            <!--  if we have a delimited deadline string  -->
            <xsl:when test="contains($deadlines, ';')">
                <!--  get the before and after the delimiter -->
                <xsl:variable name="before" select="substring-before($deadlines,';')"/>
                <xsl:variable name="after" select="substring-after($deadlines,';')"/>
                <!--  if we have a before value ... decode it -->
                <xsl:if test="$before != '' ">
                    <xsl:call-template name="decodeDeadline">
                        <xsl:with-param name="deadline">
                            <xsl:value-of select="$before"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
                <!--  if we have an after value ... decode it -->
                <xsl:if test="$after != '' ">
                    <xsl:call-template name="processDeadlines">
                        <xsl:with-param name="deadlines">
                            <xsl:value-of select="$after"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:when>
            <!--  otherwise just decode the single string that we have (if we have one) -->
            <xsl:otherwise>
                <xsl:if test="$deadlines != '' ">
                    <xsl:call-template name="decodeDeadline">
                        <xsl:with-param name="deadline">
                            <xsl:value-of select="$deadlines"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!--  decode the deadline string -->
    <xsl:template name="decodeDeadline">
        <xsl:param name="deadline"/>
            <!-- handle complete deadlines -->
            <xsl:if test="starts-with ($deadline,'complete:')">
                <xsl:variable name="complete" select="substring-after($deadline,'complete:')"/> 
                <xsl:variable name="type" select="substring-before($complete,':')"/>
                <xsl:variable name="time" select="substring-after($complete,':')"/>
                <xsl:if test="$type='for'">
                    <impl:completeFor><xsl:value-of select="$time"/></impl:completeFor>
                </xsl:if>
                <xsl:if test="$type='until'">
                    <impl:completeUntil><xsl:value-of select="$time"/></impl:completeUntil>
                </xsl:if>
            </xsl:if>
            <!-- handle start deadlines -->
            <xsl:if test="starts-with ($deadline,'start:')">
                <xsl:variable name="start" select="substring-after($deadline,'start:')"/> 
                <xsl:variable name="type" select="substring-before($start,':')"/>
                <xsl:variable name="time" select="substring-after($start,':')"/>
                <xsl:if test="$type='for'">
                    <impl:startFor><xsl:value-of select="$time"/></impl:startFor>
                </xsl:if>
                <xsl:if test="$type='until'">
                    <impl:startUntil><xsl:value-of select="$time"/></impl:startUntil>
                </xsl:if>
            </xsl:if>
    </xsl:template>
    <!-- template to see if email notificaton's have been enable via the wsdl, if there is no value set
         then the default is to send an email notification -->
    <xsl:template name="emailNotification">
        <!-- doEmailNotification when deadline passes -->
        <impl:doEmailNotification>
            <xsl:choose>
                <!--  see if a value has been passed in, use that else default to true for backwards compatibility -->
                <xsl:when test="./*[local-name()='CogManualTask_doDeadlineEmail'] != '' ">
                    <xsl:value-of select="./*[local-name()='CogManualTask_doDeadlineEmail']"/>
                </xsl:when>
                <xsl:otherwise>true</xsl:otherwise>
            </xsl:choose>                    
        </impl:doEmailNotification>
    </xsl:template>
</xsl:stylesheet>