/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.common.util;

import com.ibm.smarts.model.common.util.UniqueNameParser;

public final class UniqueNameGenerator {
    public static final String OPEN_BRACE = "[";
    public static final String CLOSE_BRACE = "]";
    public static final String BRACE_DOT = "].";
    public static final String DOT_SEPARATOR = "].[";
    public static final String DOT = ".";
    public static final String ARROW = "->";
    public static final String COLON = ":";
    private static final int THREE = 3;

    private UniqueNameGenerator() {
    }

    public static String appendUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder(part1);
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part2));
        return buffer.toString();
    }

    public static String appendUniqueName(String part1, String part2, String part3) {
        StringBuilder buffer = new StringBuilder(UniqueNameGenerator.appendUniqueName(part1, part2));
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part3));
        return buffer.toString();
    }

    public static String appendUniqueName(String part1, String part2, String part3, String part4) {
        StringBuilder buffer = new StringBuilder(UniqueNameGenerator.appendUniqueName(part1, part2, part3));
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part4));
        return buffer.toString();
    }

    public static String appendUniqueName(String part1, String part2, String part3, String part4, String part5) {
        StringBuilder buffer = new StringBuilder(UniqueNameGenerator.appendUniqueName(part1, part2, part3, part4));
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part5));
        return buffer.toString();
    }

    public static String createSingleNamePart(String part1) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        if (part1 != null) {
            buffer.append(UniqueNameParser.escapeSquareBrackets(part1));
        }
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1) {
        return UniqueNameGenerator.createSingleNamePart(part1);
    }

    public static String createUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createEscapedUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part1));
        buffer.append(DOT_SEPARATOR);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part2));
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1, String part2, String part3) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part3);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createEscapedUniqueName(String part1, String part2, String part3) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part1));
        buffer.append(DOT_SEPARATOR);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part2));
        buffer.append(DOT_SEPARATOR);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part3));
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1, String part2, String part3, String part4) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part3);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part4);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String[] parts) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        int lastPart = parts.length - 1;
        for (int i = 0; i < lastPart; ++i) {
            buffer.append(parts[i]);
            buffer.append(DOT_SEPARATOR);
        }
        buffer.append(parts[lastPart]);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String join(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(part1);
        buffer.append(DOT);
        buffer.append(part2);
        return buffer.toString();
    }

    public static String joinModelPhysicalParts(String model, String physical) {
        StringBuilder munBuf = new StringBuilder();
        munBuf.append(model);
        munBuf.append("->:");
        munBuf.append(physical);
        return munBuf.toString();
    }

    public static String joinModelLogicalPhysicalParts(String model, String logical, String physical) {
        StringBuilder munBuf = new StringBuilder();
        munBuf.append(model);
        munBuf.append(ARROW);
        if (logical != null && logical.length() > 0) {
            munBuf.append(logical);
        }
        if (physical != null && physical.length() > 0) {
            munBuf.append(COLON);
            munBuf.append(physical);
        }
        return munBuf.toString();
    }

    public static String cleanIdentifier(String identifier) {
        return identifier;
    }

    public static String getSAPBusinessKeyFromMUN(String propertyValue) {
        int partTwoEndInx;
        String memberUniqueNameKey = propertyValue;
        int partTwoStartInx = propertyValue.lastIndexOf(DOT_SEPARATOR);
        if (partTwoStartInx != -1 && (partTwoEndInx = propertyValue.indexOf(CLOSE_BRACE, partTwoStartInx += 3)) != -1 && ((memberUniqueNameKey = propertyValue.substring(partTwoStartInx, partTwoEndInx)) == null || memberUniqueNameKey.length() == 0)) {
            memberUniqueNameKey = "#";
        }
        return memberUniqueNameKey;
    }

    public static boolean hasOutterBraces(String name) {
        return name.startsWith(OPEN_BRACE) && name.endsWith(CLOSE_BRACE);
    }
}

