/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.common.util;

import com.ibm.smarts.model.common.util.UniqueNameParserException;
import java.util.ArrayList;

public class UniqueNameParser {
    private static final int LENGTHDOTSEPS = 3;
    private static final String RIGHT_SQUARE_BRACKET = "]";
    public static final String ESCAPED_RIGHT_SQUARE_BRACKET = "]]";

    public static String parseLastIdentifier(String uniqueName) throws UniqueNameParserException {
        uniqueName = UniqueNameParser.undoEscapedSquareBracket(uniqueName);
        int beginIndex = uniqueName.lastIndexOf("].&[");
        int lengthSeparator = 4;
        if (beginIndex < 0) {
            beginIndex = uniqueName.lastIndexOf("].[");
            lengthSeparator = 3;
        }
        beginIndex = beginIndex < 0 ? ((beginIndex = uniqueName.lastIndexOf("[")) >= 0 ? ++beginIndex : 0) : (beginIndex += lengthSeparator);
        int endIndex = uniqueName.length();
        if (uniqueName.endsWith(RIGHT_SQUARE_BRACKET)) {
            --endIndex;
        }
        return uniqueName.substring(beginIndex, endIndex);
    }

    public static String[] parse(String aUniqueName) throws UniqueNameParserException {
        return UniqueNameParser.parse(aUniqueName, -1);
    }

    public static String parserFirstIdentifier(String aUniqueName) throws UniqueNameParserException {
        String[] result = UniqueNameParser.parse(aUniqueName, 1);
        if (result != null && result.length > 0) {
            return result[0];
        }
        return null;
    }

    public static String[] parse(String aUniqueName, int count) throws UniqueNameParserException {
        return UniqueNameParser.parse(aUniqueName, count, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] parse(String aUniqueName, int count, boolean throwException) throws UniqueNameParserException {
        char ch;
        int pointer = 0;
        String uniqueName = aUniqueName.trim();
        if ((ch = UniqueNameParser.nextChar(pointer++, uniqueName)) == '\u0000') {
            return UniqueNameParser.handleError("XQEMessageKeys.UNP_UNIQUE_NAME_EMPTY, uniqueName, throwException");
        }
        if (ch != '[') {
            return UniqueNameParser.handleError("XQEMessageKeys.UNP_UNEXPECTED_CHAR, ch, throwException");
        }
        StringBuilder str = null;
        ArrayList<String> names = new ArrayList<String>();
        int counter = 0;
        while (ch != '\u0000' && (count == -1 || counter < count)) {
            if (str == null) {
                if (ch == '[') {
                    str = new StringBuilder("");
                } else if (ch == '&') {
                    ++counter;
                    --counter;
                } else {
                    if (ch != '.') return UniqueNameParser.handleError("XQEMessageKeys.UNP_UNEXPECTED_CHAR, ch, throwException");
                    names.add("");
                    ++counter;
                }
            } else if (ch == ']') {
                ch = UniqueNameParser.nextChar(pointer, uniqueName);
                if (ch == '\u0000') {
                    names.add(str.toString());
                    ++counter;
                    str = null;
                } else {
                    ++pointer;
                    if (ch == ']') {
                        str.append(ch);
                    } else {
                        if (ch != '.') return UniqueNameParser.handleError("XQEMessageKeys.UNP_UNEXPECTED_CHAR, ch, throwException");
                        names.add(str.toString());
                        ++counter;
                        str = null;
                    }
                }
            } else {
                str.append(ch);
            }
            if ((ch = UniqueNameParser.nextChar(pointer, uniqueName)) == '\u0000') continue;
            ++pointer;
        }
        if (str == null) return names.toArray(new String[names.size()]);
        return UniqueNameParser.handleError("XQEMessageKeys.UNP_UNEXPECTED_ID_END, uniqueName, throwException");
    }

    private static char nextChar(int pointer, String uniqueName) {
        if (pointer == uniqueName.length()) {
            return '\u0000';
        }
        return uniqueName.charAt(pointer);
    }

    private static String[] handleError(String s) {
        return null;
    }

    public static String undoEscapedSquareBracket(String identifier) {
        return identifier.replaceAll(ESCAPED_RIGHT_SQUARE_BRACKET, RIGHT_SQUARE_BRACKET);
    }

    public static String escapeSquareBrackets(String identifier) {
        if (identifier.contains(RIGHT_SQUARE_BRACKET)) {
            return identifier.replaceAll(RIGHT_SQUARE_BRACKET, ESCAPED_RIGHT_SQUARE_BRACKET);
        }
        return identifier;
    }

    public static String removeLastIdentifier(String id) {
        String[] strs = id.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length - 1; ++i) {
            sb.append(strs[i]);
            if (i == strs.length - 2) continue;
            sb.append('.');
        }
        return sb.toString();
    }
}

