/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.progress;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.model.progress.DatasetStatusMessages;
import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import java.util.ArrayList;
import java.util.List;

public class SmartsModuleProgressSummary {
    public int total;
    public int processed;
    public AnalysisStateType status;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<DatasetStatusMessages> message;

    @JsonCreator
    public SmartsModuleProgressSummary(@JsonProperty(value="total") int total, @JsonProperty(value="processed") int processed, @JsonProperty(value="status") AnalysisStateType status, @JsonProperty(value="message") List<DatasetStatusMessages> message) {
        this.total = total;
        this.processed = processed;
        this.status = status;
        this.message = message;
    }

    public SmartsModuleProgressSummary(SmartsModule smartsModule) {
        this.total = smartsModule.getDatasets().size();
        this.processed = 0;
        this.message = new ArrayList<DatasetStatusMessages>();
        this.status = smartsModule.getAnalysisState();
        this.getProgressSummaryFromSmartsModule(smartsModule);
    }

    private void getProgressSummaryFromSmartsModule(SmartsModule smartsModule) {
        List<DatasetInfo> datasetInfos = smartsModule.getDatasets();
        datasetInfos.forEach(datasetInfo -> {
            AnalysisPhase analysisPhase = datasetInfo.getAnalysisPhases().get(0);
            if (!analysisPhase.getAnalysisState().equals((Object)AnalysisStateType.IN_PROGRESS)) {
                ++this.processed;
                DatasetStatusMessages statusMessages = new DatasetStatusMessages(datasetInfo.getId(), analysisPhase.getCompletedTasks());
                if (!statusMessages.warnings.isEmpty() || !statusMessages.errors.isEmpty()) {
                    this.message.add(statusMessages);
                }
            }
        });
    }

    @JsonIgnore
    public boolean isFinished() {
        return !this.status.equals((Object)AnalysisStateType.IN_PROGRESS);
    }

    public int getTotal() {
        return this.total;
    }

    public int getProcessed() {
        return this.processed;
    }

    public AnalysisStateType getStatus() {
        return this.status;
    }

    public List<DatasetStatusMessages> getMessage() {
        return this.message;
    }
}

