/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.schema.util;

import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.FeatureType;
import org.apache.commons.lang3.StringUtils;

public class FeatureUtil {
    private static String PIPE = "|";

    private FeatureUtil() {
    }

    public static String generateFeatureID(Feature feature) {
        String assetRef;
        String smartsModuleRef = feature.getSmartsModuleRef();
        if (StringUtils.isBlank((CharSequence)smartsModuleRef)) {
            throw new IllegalArgumentException("smartsModuleRef must not be blank");
        }
        String featureKey = feature.getFeatureKey();
        if (StringUtils.isBlank((CharSequence)featureKey)) {
            throw new IllegalArgumentException("featureKey must not be blank");
        }
        String tenantID = feature.getTenantID();
        if (StringUtils.isBlank((CharSequence)tenantID)) {
            throw new IllegalArgumentException("tenantID must not be blank");
        }
        FeatureType featureType = feature.getFeatureType();
        if (featureType == null) {
            throw new IllegalArgumentException("featureType must not be null");
        }
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(Integer.toHexString(featureKey.hashCode()));
        FeatureUtil.appendHexString(idBuilder, smartsModuleRef);
        FeatureUtil.appendHexString(idBuilder, tenantID);
        FeatureUtil.appendHexString(idBuilder, featureType.toString());
        String datasetRef = feature.getDatasetRef();
        if (!StringUtils.isBlank((CharSequence)datasetRef)) {
            FeatureUtil.appendHexString(idBuilder, datasetRef);
        }
        if (!StringUtils.isBlank((CharSequence)(assetRef = feature.getAssetRef()))) {
            FeatureUtil.appendHexString(idBuilder, assetRef);
        }
        return idBuilder.toString();
    }

    private static void appendHexString(StringBuilder idBuilder, String value) {
        idBuilder.append(PIPE);
        idBuilder.append(Integer.toHexString(value.hashCode()));
    }
}

