/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.IJsonObject;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.common.logging.J2HTMLLogger;
import com.ibm.json.java.JSONObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Attributes
implements IJsonObject {
    private Hashtable attributes = new Hashtable();
    private Hashtable styleAttributes = new Hashtable();
    boolean updateStyle = false;

    public void setAttribute(String name, String value) {
        if (name != null) {
            if (value != null) {
                if ("style".equals(name)) {
                    String[] styles = value.split(";");
                    for (int i = 0; i < styles.length; ++i) {
                        String[] style = styles[i].split(":");
                        if (style.length != 2) {
                            throw new IllegalArgumentException("Style attribute name=" + style[0] + " cannot be null");
                        }
                        this.setStyle(style[0].trim(), style.length > 1 ? style[1].trim() : null);
                    }
                } else {
                    this.attributes.put(name, value);
                }
            } else {
                this.removeAttribute(name);
                if (J2HTMLLogger.getInstance().isDebugEnabled()) {
                    J2HTMLLogger.getInstance().debug(this.getClass().getName() + " setAttribute(name,value) for name=" + name + ") value = null. Removing...");
                }
            }
        } else {
            throw new IllegalArgumentException("Attribute name cannot be null. name=" + name);
        }
    }

    void setAttribute(String name, JSONObject value) {
        if (value != null) {
            this.setAttribute(name, value.toString());
        } else {
            this.removeAttribute(name);
            J2HTMLLogger.getInstance().debug(this.getClass().getName() + " setAttribute(name,value) for name=" + name + ") value = null. Removing...");
        }
    }

    String removeAttribute(String name) {
        if (name != null) {
            String value = (String)this.attributes.remove(name);
            if ("style".equals(name)) {
                this.styleAttributes.clear();
                this.updateStyle = true;
            }
            return value;
        }
        throw new IllegalArgumentException("Attribute name cannot be null");
    }

    void setStyle(String name, String value) {
        if (name != null) {
            if (value != null) {
                if (!this.styleAttributes.contains(value)) {
                    this.styleAttributes.put(name, value);
                }
            } else {
                this.removeStyle(name);
                J2HTMLLogger.getInstance().debug(this.getClass().getName() + " setStyle(name,value) for name=" + name + ") value = null. Removing...");
            }
        } else {
            throw new IllegalArgumentException("Style attribute name cannot be null. name=" + name);
        }
        this.updateStyle = true;
    }

    String removeStyle(String name) {
        if (name != null) {
            this.updateStyle = true;
            return (String)this.styleAttributes.remove(name);
        }
        throw new IllegalArgumentException("Style Attribute name cannot be null");
    }

    void writeAttributes(XMLStreamWriter writer) throws XMLStreamException {
        this.writeAttributes(writer, false);
    }

    void writeAttributes(XMLStreamWriter writer, boolean clear) throws XMLStreamException {
        if (this.updateStyle) {
            this.updateStyle();
        }
        for (Map.Entry entry : this.attributes.entrySet()) {
            String name = entry.getKey().toString();
            String value = this.onWriteAttribute(name, entry.getValue());
            writer.writeAttribute(name, value);
        }
        if (clear) {
            this.clearAttributes();
        }
    }

    protected String onWriteAttribute(String name, Object object) {
        return object.toString();
    }

    private void updateStyle() {
        this.updateStyle = false;
        StringBuffer style = new StringBuffer();
        for (Map.Entry entry : this.styleAttributes.entrySet()) {
            String styleName = entry.getKey().toString();
            style.append(styleName).append(':').append(entry.getValue()).append(';');
        }
        if (this.styleAttributes.size() > 0) {
            this.attributes.put("style", style.toString());
        } else {
            this.attributes.remove("style");
        }
    }

    String getStyleAttribute(String name) {
        return (String)this.styleAttributes.get(name);
    }

    public String getAttribute(String name) {
        if (this.updateStyle) {
            this.updateStyle();
        }
        return (String)this.attributes.get(name);
    }

    Iterator getAttributeNames() {
        if (this.updateStyle) {
            this.updateStyle();
        }
        return this.attributes.keySet().iterator();
    }

    int getAttributeCount() {
        if (this.updateStyle) {
            this.updateStyle();
        }
        return this.attributes.size();
    }

    void clearAttributes() {
        this.styleAttributes.clear();
        this.attributes.clear();
    }

    public void setWidth(String width) {
        this.setStyle("width", width);
    }

    public void setTextAlign(String align) {
        this.setStyle("text-align", align);
    }

    public void setBackgroundColor(String color) {
        this.setStyle("background-color", color);
    }

    public void setBackground(String path, String position) {
        this.setStyle("background", new StringBuffer("url(").append(path).append(") ").append(position).append(" no-repeat").toString());
    }

    public void setHeight(String height) {
        this.setStyle("height", height);
    }

    public void setBorder(String border) {
        this.setStyle("border", border);
    }

    public void setBorderLeft(String border) {
        this.setStyle("border-left", border);
    }

    public void setBorderRight(String border) {
        this.setStyle("border-right", border);
    }

    public void setPadding(String padding) {
        this.setStyle("padding", padding);
    }

    public void setPaddingLeft(String padding) {
        this.setStyle("padding-left", padding);
    }

    public void setPaddingRight(String padding) {
        this.setStyle("padding-right", padding);
    }

    public void setVerticalAlign(String verticalAlign) {
        this.setStyle("vertical-align", verticalAlign);
    }

    public void setVisible(boolean visible) {
        this.setStyle("display", visible ? "block" : "none");
    }

    public boolean isVisible() {
        String display = this.getStyleAttribute("display");
        return !"none".equals(display);
    }

    public void hide(boolean collapse) {
        this.setStyle("display", collapse ? "none" : "none");
    }

    public void hide() {
        this.hide(false);
    }

    public void setToolTip(String title) {
        if (title != null) {
            this.setAttribute("title", title);
        }
    }

    public String getToolTip() {
        return this.getAttribute("title");
    }

    public void supportTabbing(boolean tabable) {
        this.setAttribute("tabindex", tabable ? "0" : "-1");
    }

    @Override
    public JSONObject toJson() throws J2HTMLException {
        JSONObject jsonObj = new JSONObject();
        if (this.updateStyle) {
            this.updateStyle();
        }
        Enumeration _enum = this.attributes.keys();
        while (_enum.hasMoreElements()) {
            String name = (String)_enum.nextElement();
            String value = this.onWriteAttribute(name, this.getAttribute(name));
            jsonObj.put((Object)name, (Object)value);
        }
        return jsonObj;
    }
}

