/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.ActionComponent;
import com.cognos.admin.j2html.J2HTMLException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CheckBox
extends ActionComponent {
    private boolean checked = false;
    private boolean disabled = false;
    private String label;

    public CheckBox() {
        this(null, Boolean.TRUE);
    }

    public CheckBox(String label) {
        this.setLabel(label);
    }

    public CheckBox(String name, Object value) {
        this.setAttribute("type", "checkbox");
        this.setName(name);
        this.setValue(value);
    }

    public void setChecked(Boolean checked) {
        if (checked != null) {
            this.setChecked((boolean)checked);
        }
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        if (checked) {
            this.setAttribute("checked", "");
        } else {
            this.removeAttribute("checked");
        }
    }

    public void setDisabled(Boolean disabled) {
        if (disabled != null) {
            this.setDisabled((boolean)disabled);
        }
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (disabled) {
            this.setAttribute("disabled", "");
        } else {
            this.removeAttribute("disabled");
        }
    }

    public void setValue(Object value) {
        this.setAttribute("value", value.toString());
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.removeAttribute("disabled");
        } else {
            this.setAttribute("disabled", "true");
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.setStyle("vertical-align", "middle");
    }

    @Override
    public final void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        if (this.getLabel() != null) {
            this.writeCheckBox(staxWriter);
            staxWriter.writeStartElement("label");
            if (!this.isVisible()) {
                staxWriter.writeAttribute("style", "visibility:hidden");
            }
            if (this.getContext().getUniqueID() != null) {
                staxWriter.writeAttribute("for", this.getContext().getUniqueID() + this.getAttribute("id"));
            }
            staxWriter.writeCharacters(this.getLabel());
            staxWriter.writeEndElement();
        } else {
            this.writeCheckBox(staxWriter);
        }
    }

    private void writeCheckBox(XMLStreamWriter staxWriter) throws XMLStreamException {
        staxWriter.writeStartElement("input");
        this.writeAttributes(staxWriter);
        staxWriter.writeEndElement();
    }
}

