/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.IContainer;
import com.cognos.admin.j2html.J2HTMLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Container
extends Component
implements IContainer {
    private ArrayList components = new ArrayList();

    @Override
    public void add(Component c) {
        c.parent = this;
        this.components.add(c);
        c.setContext(this.getContext());
    }

    @Override
    public void add(Component c, int index) {
        this.components.ensureCapacity(index);
        this.components.add(index, c);
        c.parent = this;
        c.setContext(this.getContext());
    }

    @Override
    public void addAll(Component[] comps) {
        for (int i = 0; i < comps.length; ++i) {
            this.add(comps[i]);
        }
    }

    @Override
    public void removeAll(Component[] comps) {
        this.components.removeAll(Arrays.asList(comps));
    }

    @Override
    public boolean remove(Component c) {
        return this.components.remove(c);
    }

    @Override
    public Component remove(int index) {
        return (Component)this.components.remove(index);
    }

    @Override
    public void removeAll() {
        this.components.clear();
    }

    @Override
    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public Component getComponent(int i) {
        return (Component)this.components.get(i);
    }

    public int getComponentIndex(Component child) {
        return this.components.indexOf(child);
    }

    public Iterator getComponents() {
        return this.components.iterator();
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        for (Component component : this.components) {
            if (!component.isRenderable()) continue;
            component.setContext(this.getContext());
            component.init();
            component.writeMarkup(staxWriter);
        }
    }

    @Override
    public String[] getSkipPersistClientState() {
        ArrayList<String> aPersists = new ArrayList<String>();
        Iterator iter = this.getComponents();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            String[] _tmpPersists = comp.getSkipPersistClientState();
            if (_tmpPersists == null) continue;
            for (int i = 0; i < _tmpPersists.length; ++i) {
                aPersists.add(_tmpPersists[i]);
            }
        }
        if (aPersists.size() > 0) {
            String[] persists = new String[aPersists.size()];
            for (int i = 0; i < aPersists.size(); ++i) {
                persists[i] = aPersists.get(i).toString();
            }
            return persists;
        }
        return null;
    }
}

