/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.Container;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.common.message.MessagesManagerFacade;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IControlledComponent;
import com.cognos.admin.j2html.control.IControllerEvent;
import com.cognos.xts.ext.XTSExt;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class ControlledComponent
extends Container
implements IControlledComponent {
    private ArrayList events = new ArrayList();
    JSONObject cogParam = new JSONObject();
    JSONObject publicVars = null;
    JSONObject clientState = null;
    protected static final String MIME_TYPE_HTML = "html";
    private boolean displayTimeStamp = false;

    public ControlledComponent(IContext context) {
        this(context, false);
    }

    public ControlledComponent(IContext context, boolean displayTimeStamp) {
        super.setContext(context);
        this.displayTimeStamp = displayTimeStamp;
        this.setID("cog_controlled_div");
        this.setAttribute("cogtype", "table_init");
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        if (MIME_TYPE_HTML.equals(this.getMimeType())) {
            staxWriter.writeStartElement("div");
            JSONArray fragArray = new JSONArray();
            this.cogParam.put((Object)"fragment", (Object)fragArray);
            for (IControllerEvent event : this.events) {
                JSONObject evtObj = new JSONObject();
                evtObj.put((Object)"fnName", (Object)event.getFunction());
                evtObj.put((Object)"evt", (Object)event.getName());
                evtObj.put((Object)"evtContext", (Object)event.getContext());
                fragArray.add((Object)evtObj);
            }
            if (this.publicVars == null) {
                this.publicVars = new JSONObject();
            }
            this.publicVars.put((Object)"contentTableId", (Object)(this.getContext().getUniqueID() + "contentTable"));
            this.publicVars.put((Object)"numRow", (Object)this.getNumRow());
            this.publicVars.put((Object)"depth", (Object)this.getDepth());
            this.publicVars.put((Object)"skipPersistClientState", (Object)this.getJSONSkipPersistClientState());
            this.cogParam.put((Object)"publicVar", (Object)this.publicVars);
            if (this.clientState != null) {
                this.cogParam.put((Object)"state", (Object)this.clientState);
            }
            this.setAttribute("cogparam", this.cogParam.toString());
            this.writeAttributes(staxWriter);
            super.writeMarkup(staxWriter);
            if (this.displayTimeStamp) {
                staxWriter.writeStartElement("div");
                staxWriter.writeAttribute("class", "cogstyle-table-footer");
                staxWriter.writeStartElement("table");
                staxWriter.writeAttribute("cellspacing", "0");
                staxWriter.writeAttribute("cellpadding", "0");
                staxWriter.writeAttribute("border", "0");
                staxWriter.writeAttribute("style", "width:100%");
                staxWriter.writeStartElement("tbody");
                staxWriter.writeStartElement("tr");
                staxWriter.writeStartElement("td");
                try {
                    String timeStamp = XTSExt.formatDateFromUTC((String)XTSExt.getCurrentDateTime((String)this.getContext().getTimeZone()), (int)2, (int)3, (String)"", (String)this.getContext().getEnv().getContentLocale());
                    staxWriter.writeCharacters(this.getContext().localize(MessagesManagerFacade.getInstance().getMessage(this.getContext().getEnv().getProductLocale(), "IDS_LAST_REFRESH", (Object[])new String[]{timeStamp})));
                }
                catch (Exception e) {
                    throw new J2HTMLException(e);
                }
                staxWriter.writeEndElement();
                staxWriter.writeEndElement();
                staxWriter.writeEndElement();
                staxWriter.writeEndElement();
                staxWriter.writeEndElement();
            }
            staxWriter.writeStartElement("script");
            staxWriter.writeAttribute("type", "text/javaScript");
            staxWriter.writeCharacters("new com.cognos.admin.widget.Builder($('" + this.getComponentID() + "')," + this.getContext().getUniqueID() + ").populateTable();");
            staxWriter.writeCharacters(new StringBuffer(this.getContext().getUniqueID()).append("callBack = function(skipRefresh) {ui_modal_dialog.close(); if (!skipRefresh) {").append(this.getContext().getUniqueID()).append(".raiseEvent('fragment.refresh');}}").toString());
            staxWriter.writeEndElement();
            staxWriter.writeEndElement();
        } else {
            super.writeMarkup(staxWriter);
        }
    }

    @Override
    public void fireEvent(IControllerEvent event) {
        this.events.add(event);
    }

    @Override
    public String getMimeType() {
        String mimeType = this.getContext().getEnv().getParameter("mimeType");
        return mimeType == null ? MIME_TYPE_HTML : mimeType;
    }

    @Override
    public String getComponentID() {
        return new StringBuffer(this.getContext().getUniqueID()).append("content").toString();
    }

    @Override
    public void addClientPublicVariable(JSONObject value, boolean persist) {
        if (persist) {
            if (this.clientState == null) {
                this.clientState = new JSONObject();
            }
            ControlledComponent.appendJSON(this.clientState, value);
        } else {
            if (this.publicVars == null) {
                this.publicVars = new JSONObject();
            }
            ControlledComponent.appendJSON(this.publicVars, value);
        }
    }

    public JSONObject getClientState() {
        return this.clientState;
    }

    private JSONArray getJSONSkipPersistClientState() {
        String[] skipPersists = this.getSkipPersistClientState();
        JSONArray result = null;
        if (skipPersists != null) {
            result = new JSONArray();
            for (int i = 0; i < skipPersists.length; ++i) {
                result.add((Object)skipPersists[i]);
            }
        }
        return result;
    }

    private static void appendJSON(JSONObject appender, JSONObject appendee) {
        Iterator iter = appendee.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            appender.put((Object)key, appendee.get((Object)key));
        }
    }
}

