/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.ActionComponent;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.actions.AbstractAction;
import com.cognos.admin.j2html.actions.ActionImpl;
import com.cognos.admin.j2html.common.logging.J2HTMLLogger;
import com.ibm.json.java.JSONObject;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Image
extends ActionComponent {
    public static final String SMALL_ICON_WIDTH = "16px";
    private static final String SLASH = "/";
    private static final String EMPTY_STRING = "";
    private String path;
    private String alt;
    private boolean isAbsolute = false;
    private AbstractAction tooltip = null;
    private boolean changeBackground = false;

    public Image() {
        this(EMPTY_STRING);
    }

    public Image(String path) {
        this.setPath(path, false);
        this.setAlt(EMPTY_STRING);
    }

    public void setPath(String path, boolean isAbsolute) {
        if (path == null && J2HTMLLogger.getInstance().isWarnEnabled()) {
            J2HTMLLogger.getInstance().warn(this.getClass().getName() + " setPath(path,isAbsolute) path is null.");
        }
        this.isAbsolute = isAbsolute;
        this.path = isAbsolute ? path : this.getRelPath(path);
    }

    private String getRelPath(String path) {
        if (path != null && !path.startsWith(SLASH)) {
            StringBuffer sbPath = new StringBuffer();
            sbPath.append(SLASH);
            path = sbPath.append(path).toString();
        }
        return path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public void setRelativePath(String path) {
        this.setPath(path, false);
    }

    protected String getFullPath(String path) {
        return new StringBuffer(this.getContext().getEnv().getWebContent()).append(path).toString();
    }

    public void setDisabled(boolean disabled) {
        if (disabled) {
            this.setAttribute("class", "hiddenEntryIcon");
        } else {
            this.removeAttribute("class");
        }
        this.setAttribute("aria-disabled", Boolean.toString(disabled));
    }

    public void setAlt(String alt) {
        this.alt = alt == null ? EMPTY_STRING : alt;
    }

    @Override
    public void init() throws J2HTMLException {
        String title;
        super.init();
        this.setAttribute("src", this.isAbsolute ? this.path : this.getFullPath(this.path));
        this.setAttribute("alt", this.alt);
        if (this.alt != null && this.alt.isEmpty() && (title = this.getAttribute("title")) != null && !title.isEmpty()) {
            this.setAttribute("alt", title);
        }
        if (this.getAction() != null) {
            if (this.getChangeBackground()) {
                this.setAttribute("class", "cogstyle-toolbar-imageNormal");
            }
            this.setAttribute("border", "0");
            this.setStyle("vertical-align", "middle");
        } else if (this.tooltip != null) {
            this.setAction(new ActionImpl(){

                @Override
                public String getCogType() {
                    return Image.this.tooltip.getCogType();
                }

                @Override
                public JSONObject getCogParam() throws J2HTMLException {
                    return Image.this.tooltip.getCogParam();
                }
            });
        }
    }

    public boolean getChangeBackground() {
        return this.changeBackground;
    }

    public void setChangeBackground(boolean changeBackground) {
        this.changeBackground = changeBackground;
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        this.init();
        staxWriter.writeStartElement("img");
        this.writeAttributes(staxWriter);
        staxWriter.writeEndElement();
    }
}

