/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.ActionComponent;
import com.cognos.admin.j2html.Container;
import com.cognos.admin.j2html.IJsonObject;
import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.MenuItem;
import com.cognos.admin.j2html.SkinImage;
import com.cognos.admin.j2html.actions.MenuAction;
import com.cognos.admin.j2html.common.logging.J2HTMLLogger;
import com.cognos.admin.j2html.common.message.MessagesManagerFacade;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Menu
extends ActionComponent
implements IJsonObject {
    private Image menuImage = null;
    private Container container = new Container();
    private boolean isDropDown;

    public Menu() {
        this(true);
    }

    public Menu(boolean isDropDown) {
        this.isDropDown = isDropDown;
        if (isDropDown) {
            this.menuImage = new SkinImage("/shared/images/dropdown_arrow.gif");
            this.attachMenuTo(this.menuImage);
        }
    }

    public boolean isDropDown() {
        return this.isDropDown;
    }

    public void addMenuItem(MenuItem menuItem) {
        this.container.add(menuItem);
    }

    public void addMenuItem(MenuItem menuItem, int idx) {
        this.container.add(menuItem, idx);
    }

    public void removeMenuItem(MenuItem menuItem) {
        this.container.remove(menuItem);
    }

    public MenuItem removeMenuItem(int idx) {
        return (MenuItem)this.container.remove(idx);
    }

    public Iterator getMenuItems() {
        return this.container.getComponents();
    }

    public int getMenuItemCount() {
        return this.container.getComponentCount();
    }

    @Override
    public void init() throws J2HTMLException {
        this.container.setContext(this.getContext());
        this.container.init();
    }

    protected void attachMenuTo(ActionComponent comp) {
        comp.setAttribute("onclick", "");
        comp.setAction(new MenuAction(){

            @Override
            public JSONObject getCogParam() throws J2HTMLException {
                JSONObject cogParamObj = new JSONObject();
                cogParamObj.put((Object)"actionType", (Object)this.getActionType());
                cogParamObj.put((Object)"model", (Object)Menu.this.toJson());
                return cogParamObj;
            }
        });
    }

    protected JSONArray getJSONMenuItems() throws J2HTMLException {
        JSONArray items = new JSONArray();
        Iterator iter = this.getMenuItems();
        while (iter.hasNext()) {
            try {
                JSONObject jsonItem = ((MenuItem)iter.next()).toJson();
                items.add((Object)jsonItem);
            }
            catch (ClassCastException e) {
                J2HTMLLogger.getInstance().error(e.getMessage());
            }
        }
        if (items.size() == 0) {
            MenuItem emptyItem = new MenuItem(MessagesManagerFacade.getInstance().getMessage(this.getContext().getEnv().getProductLocale(), "IDS_MENU_EMPTY"));
            items.add((Object)emptyItem.toJson());
        }
        return items;
    }

    @Override
    public JSONObject toJson() throws J2HTMLException {
        JSONObject jsonObj = new JSONObject();
        if (this.getID() != null) {
            jsonObj.put((Object)"id", (Object)this.getID());
        }
        jsonObj.put((Object)"items", (Object)this.getJSONMenuItems());
        return jsonObj;
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        this.init();
        if (this.isDropDown) {
            this.menuImage.setContext(this.getContext());
            if (this.menuImage.getToolTip() == null) {
                this.menuImage.setToolTip(this.getToolTip());
            }
            this.menuImage.writeMarkup(staxWriter);
        } else {
            this.container.writeMarkup(staxWriter);
        }
    }
}

