/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.ActionComponent;
import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.Link;
import com.cognos.admin.j2html.Menu;
import com.cognos.admin.j2html.actions.IAction;
import com.cognos.admin.j2html.common.logging.J2HTMLLogger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MenuItem
extends Menu {
    private String label;
    private Image image;
    private boolean enabled = true;
    private boolean separatorBefore = false;
    private boolean selected = false;
    private Link link = new Link();
    private String value = null;
    private String iconPath;

    public MenuItem() {
    }

    public MenuItem(String label) {
        this(label, null);
    }

    public MenuItem(Image image) {
        this(null, image);
    }

    public MenuItem(String label, Image image) {
        this.label = label;
        this.image = image;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSeparatorBefore(boolean separatorBefore) {
        this.separatorBefore = separatorBefore;
    }

    public boolean hasSeparatorBefore() {
        return this.separatorBefore;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        ActionComponent actionObj;
        if (this.image != null) {
            actionObj = this.image;
            this.image.setToolTip(this.label);
        } else {
            actionObj = this.link;
            this.link.setText(this.label);
        }
        actionObj.setContext(this.getContext());
        actionObj.setAction(this.getAction());
        actionObj.writeMarkup(staxWriter);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public JSONObject toJson() throws J2HTMLException {
        IAction action;
        JSONObject jsonItem = new JSONObject();
        jsonItem.put((Object)"title", (Object)this.getLabel());
        if (this.getValue() != null) {
            jsonItem.put((Object)"id", (Object)this.getValue());
        }
        if (this.hasSeparatorBefore()) {
            jsonItem.put((Object)"separatorBefore", (Object)true);
        }
        if (this.isSelected()) {
            jsonItem.put((Object)"selected", (Object)true);
        }
        if (this.getImage() != null) {
            jsonItem.put((Object)"image", (Object)this.getImage().getPath());
        }
        if ((action = this.getAction()) != null) {
            if (this.isEnabled()) {
                jsonItem.put((Object)"action", (Object)action.getCogParam());
            }
        } else if (this.isEnabled()) {
            jsonItem.put((Object)"action", (Object)true);
        }
        jsonItem.put((Object)"items", (Object)this.getJSONMenuItems());
        return jsonItem;
    }

    @Override
    protected JSONArray getJSONMenuItems() throws J2HTMLException {
        JSONArray items = new JSONArray();
        Iterator iter = this.getMenuItems();
        while (iter.hasNext()) {
            try {
                JSONObject jsonItem = ((MenuItem)iter.next()).toJson();
                items.add((Object)jsonItem);
            }
            catch (ClassCastException e) {
                J2HTMLLogger.getInstance().error(e.getMessage());
            }
        }
        return items;
    }
}

