/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.Container;
import com.cognos.admin.j2html.DefaultTableLayoutHandler;
import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.Label;
import com.cognos.admin.j2html.TableLayoutPane;
import com.cognos.admin.j2html.common.logging.J2HTMLLogger;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Message
extends Component {
    public static final String MSGTYPE_INFORMATION = "inf";
    public static final String MSGTYPE_WARNING = "wrn";
    public static final String MSGTYPE_ERROR = "err";
    public static final String MSGTYPE_FATAL = "ftl";
    public static final String MSGTYPE_DEBUG = "dbg";
    private static HashMap iconMap = new HashMap(5);
    private String messageType;
    private TableLayoutPane messageTableLayout = new TableLayoutPane(1, 2);
    private DefaultTableLayoutHandler messageTableLayoutHandler = new DefaultTableLayoutHandler();
    private Image messageIcon = new Image();
    private Label messageLabel = new Label();
    private Container container = new Container();

    public Message() {
        this.messageTableLayout.setTableLayoutHandler(this.messageTableLayoutHandler);
        this.messageTableLayoutHandler.add(this.messageIcon, 0, 0);
        this.messageTableLayoutHandler.add(this.messageLabel, 0, 1);
        this.container.add(this.messageTableLayout);
        this.setMessageType(MSGTYPE_INFORMATION);
    }

    public String getMessageText() {
        return this.messageLabel.getText();
    }

    public void setMessageText(String messageText) {
        this.messageLabel.setText(messageText);
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) throws IllegalArgumentException {
        if (!iconMap.containsKey(messageType)) {
            String exceptionMsg = "Unknown message type: <" + messageType + ">";
            J2HTMLLogger.getInstance().error(exceptionMsg);
            throw new IllegalArgumentException(exceptionMsg);
        }
        this.messageType = messageType;
        this.messageIcon.setPath(this.getIconPath(this.messageType), false);
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        this.container.setContext(this.getContext());
        this.container.init();
        this.container.writeMarkup(staxWriter);
    }

    protected String getIconPath(String messageType) {
        return "/ps/portal/images/" + (String)iconMap.get(messageType);
    }

    static {
        iconMap.put(MSGTYPE_INFORMATION, "msg_information.gif");
        iconMap.put(MSGTYPE_WARNING, "msg_warning.gif");
        iconMap.put(MSGTYPE_ERROR, "msg_error.gif");
        iconMap.put(MSGTYPE_FATAL, "msg_fatal.gif");
        iconMap.put(MSGTYPE_DEBUG, "msg_debug.gif");
    }
}

