/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.Attributes;
import com.cognos.admin.j2html.CheckBox;
import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.Container;
import com.cognos.admin.j2html.DefaultTableCellRenderer;
import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.TableFooter;
import com.cognos.admin.j2html.TableHeader;
import com.cognos.admin.j2html.actions.AbstractAction;
import com.cognos.admin.j2html.actions.CheckBoxTogglerAction;
import com.cognos.admin.j2html.common.message.MessagesManagerFacade;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IEnvironment;
import com.cognos.admin.j2html.table.BooleanTableCellRenderer;
import com.cognos.admin.j2html.table.DefaultSortFilterTableModel;
import com.cognos.admin.j2html.table.DefaultTableColumnComparator;
import com.cognos.admin.j2html.table.DefaultTableModel;
import com.cognos.admin.j2html.table.DefaultTableRowRenderer;
import com.cognos.admin.j2html.table.ISortFilterTableModel;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.ITableModel;
import com.cognos.admin.j2html.table.ITableRowRenderer;
import com.cognos.admin.j2html.table.ImageTableCellRenderer;
import com.cognos.admin.j2html.table.TableColumnFilter;
import com.cognos.admin.j2html.table.TableColumnModel;
import com.cognos.admin.j2html.utils.JSONUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Table
extends Container {
    public static final String DEFAULT_EMPTY_TABLE_WIDTH = "400";
    private static final String CLIENTSTATE_SELECTED_ROW = "selectedRow";
    private static final String CLIENTSTATE_GROUP_ACTION_ROWS = "grpActionRows";
    protected transient Hashtable defaultRenderersByColumnClass = new Hashtable();
    protected transient Hashtable defaultTableColumnComparators = new Hashtable();
    protected transient Hashtable defaultColumnFilters = new Hashtable();
    private transient DefaultTableColumnComparator defaultComparator = new DefaultTableColumnComparator();
    private BitSet rowSelectionModel;
    private TableHeader tableHeader;
    private TableFooter tableFooter;
    private ITableModel dataModel;
    private TableColumnModel columnModel;
    private ISortFilterTableModel sortFilterModel;
    private ITableRowRenderer tableRowRenderer = null;
    private boolean sortable;
    private boolean filterable;
    private boolean displayEmptyTableText;
    private boolean subTable = false;
    private boolean supportsListViewSeparatorPreference = true;
    private int idx = 0;
    private int tableIdx = 1;
    private Image colSeparatorImg = null;
    private int sortFromIdx = 0;
    private int sortToIdx = -1;
    private boolean supportsGroupActions = false;
    private boolean displayGroupActions = true;
    private boolean persistGroupActions = true;
    private String[] selectedRowKeys = null;
    private String selectedRowStateKey = null;

    public Table() {
        this((ITableModel)null);
        this.setDefaultAttributes();
        this.setDefaultRenderer(new DefaultTableCellRenderer());
    }

    public Table(ITableModel dataModel) {
        this(dataModel, null);
    }

    public Table(ITableModel dataModel, TableColumnModel columnModel) {
        if (dataModel == null) {
            dataModel = new DefaultTableModel();
        }
        this.setModel(dataModel);
        this.setColumnModel(columnModel);
        this.setDefaultAttributes();
        this.setDefaultRenderer(new DefaultTableCellRenderer());
        this.tableRowRenderer = new DefaultTableRowRenderer();
    }

    public int getTableIdx() {
        return this.tableIdx;
    }

    public void setTableHeader(TableHeader tableHeader) {
        this.tableHeader = tableHeader;
    }

    public void setTableFooter(TableFooter tableFooter) {
        this.tableFooter = tableFooter;
    }

    public TableHeader getTableHeader() {
        if (this.tableHeader == null) {
            this.setTableHeader(new TableHeader(this));
        }
        return this.tableHeader;
    }

    public TableFooter getTableFooter() {
        if (this.tableFooter == null) {
            this.setTableFooter(new TableFooter(this));
        }
        return this.tableFooter;
    }

    @Override
    public void init() throws J2HTMLException {
        this.tableIdx = this.isSubTable() ? ((Table)this.getParent()).getTableIdx() : this.getContext().getNextTableIdx();
        if (this.getDefaultRenderer(Object.class) == null) {
            this.setDefaultRenderers();
        }
        if (this.sortable || this.filterable) {
            this.getSortFilterTableModel();
            this.setSortedColumn();
        }
        this.initColSeparator();
        this.selectedRowKeys = new String[]{(String)this.getContext().getClientStateParameter(this, CLIENTSTATE_SELECTED_ROW)};
        List<String> selectedKeys = Arrays.asList(this.selectedRowKeys);
        ITableRowRenderer rowRenderer = this.getRowRenderer();
        if (rowRenderer != null) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                rowRenderer.init(this, row);
                String key = rowRenderer.getSelectedRowStateKey();
                if (key == null) continue;
                try {
                    if (!selectedKeys.contains(key)) continue;
                    this.selectRow(row);
                    continue;
                }
                catch (Exception e) {
                    throw new J2HTMLException(e);
                }
            }
        }
    }

    private void initColSeparator() {
        this.colSeparatorImg = new Image("/ps/images/space.gif");
        this.colSeparatorImg.setAttribute("height", "15");
        this.colSeparatorImg.setAttribute("width", "1");
        this.colSeparatorImg.setAttribute("alt", "");
        this.colSeparatorImg.setBackgroundColor("#9C9C9C");
    }

    Image getColSeparator() {
        return this.colSeparatorImg;
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        if (!this.subTable) {
            staxWriter.writeStartElement("div");
            staxWriter.writeStartElement("div");
            staxWriter.writeAttribute("class", "cogstyle-table-wrapper");
            if ("none".equals(this.getStyleAttribute("display"))) {
                staxWriter.writeAttribute("style", "display:none");
            }
            if (this.tableFooter != null) {
                staxWriter.writeAttribute("id", this.getContext().getUniqueID() + "contentTable");
            }
            staxWriter.writeStartElement("table");
            staxWriter.writeAttribute("class", "cogstyle-table");
            this.setAttribute("cellspacing", "0");
            this.setAttribute("cellpadding", "0");
            this.setAttribute("border", "0");
            this.setAttribute("style", "border-collapse:collapse;overflow:auto;");
            if (this.getActiveModel().getSummary() != null && !this.getActiveModel().getSummary().isEmpty()) {
                this.setAttribute("summary", this.getActiveModel().getSummary());
            }
            this.writeAttributes(staxWriter, true);
        }
        if (this.getTableHeader().isRenderable()) {
            this.getTableHeader().setContext(this.getContext());
            if ((this.isSubTable() || this.getComponentCount() == 0) && this.getActiveModel().getRowCount() < 2) {
                this.setSortable(false);
            }
            this.getTableHeader().writeMarkup(staxWriter);
        }
        if (!this.subTable) {
            staxWriter.writeStartElement("tbody");
            staxWriter.writeAttribute("class", "cogstyle-table-body");
        }
        this.initSubTables();
        this.renderModelMarkup(staxWriter);
        super.writeMarkup(staxWriter);
        if (!this.subTable) {
            staxWriter.writeEndElement();
            if (this.tableFooter != null && this.tableFooter.isRenderable()) {
                staxWriter.writeStartElement("tfoot");
                staxWriter.writeAttribute("class", "cogstyle-table-footer");
                staxWriter.writeAttribute("width", "100%");
                staxWriter.writeAttribute("cellspacing", "0");
                staxWriter.writeAttribute("border", "0");
                this.tableFooter.setContext(this.getContext());
                this.tableFooter.writeMarkup(staxWriter);
                staxWriter.writeEndElement();
            }
            staxWriter.writeEndElement();
            staxWriter.writeEndElement();
            staxWriter.writeEndElement();
        }
    }

    public ITableModel getModel() {
        return this.dataModel;
    }

    private ITableModel getActiveModel() {
        return this.sortFilterModel != null ? this.sortFilterModel : this.dataModel;
    }

    public void setModel(ITableModel dataModel) {
        this.dataModel = dataModel;
        this.setColumnModel(this.columnModel);
        this.rowSelectionModel = new BitSet(dataModel.getRowCount());
    }

    public void selectRow(int row) {
        this.rowSelectionModel.set(row);
    }

    public boolean isRowSelected(int row) {
        return this.rowSelectionModel.get(row);
    }

    public int getSelectedRowCount() {
        return this.rowSelectionModel.cardinality();
    }

    public String[] getSelectedRowKeys() throws J2HTMLException {
        return this.selectedRowKeys;
    }

    public void addColumn(TableColumn aColumn) {
        if (aColumn.getHeaderValue() == null) {
            int modelColumn = aColumn.getModelIndex();
            String columnName = this.getActiveModel().getColumnName(modelColumn);
            aColumn.setHeaderValue(columnName);
        }
        this.columnModel.addColumn(aColumn);
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setColumnModel(TableColumnModel columnModel) {
        this.columnModel = columnModel;
        this.setSortable(this.sortable);
        if (columnModel != null) {
            this.getTableHeader();
        }
    }

    public void createDefaultColumnsFromModel() {
        if (this.columnModel == null) {
            this.columnModel = new TableColumnModel();
        }
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            TableColumn column = new TableColumn(i);
            column.setSortable(this.sortable, false);
            column.setHeaderValue(this.getActiveModel().getColumnName(i));
            this.columnModel.addColumn(column);
        }
    }

    public TableColumn getColumn(int col) {
        return this.getColumnModel().getColumn(col);
    }

    public ITableCellRenderer getTableCellRenderer(int row, int column) {
        TableColumn tableColumn = this.getColumn(column);
        ITableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null && (renderer = this.getDefaultRenderer(this.getColumnClass(column))) == null) {
            renderer = this.getDefaultRenderer(this.getModel().getValueAt(row, column).getClass());
        }
        return renderer;
    }

    public void setDefaultRenderers() {
        this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.setDefaultRenderer(Boolean.class, new BooleanTableCellRenderer());
        this.setDefaultRenderer(Image.class, new ImageTableCellRenderer());
    }

    public void setDefaultRenderer(Class columnClass, ITableCellRenderer renderer) {
        this.defaultRenderersByColumnClass.put(columnClass, renderer);
    }

    public void setDefaultRenderer(ITableCellRenderer renderer) {
        this.defaultRenderersByColumnClass.put(Object.class, renderer);
    }

    public void setDefaultColumnFilter(String name, TableColumnFilter filter) {
        this.defaultColumnFilters.put(name, filter);
    }

    public TableColumnFilter getFilter(String name) {
        return (TableColumnFilter)this.defaultColumnFilters.get(name);
    }

    public ITableCellRenderer getDefaultRenderer(Class columnClass) {
        if (columnClass == null) {
            return this.getDefaultRenderer(Object.class);
        }
        Object renderer = this.defaultRenderersByColumnClass.get(columnClass);
        if (renderer != null) {
            return (ITableCellRenderer)renderer;
        }
        return this.getDefaultRenderer(columnClass.getSuperclass());
    }

    public Comparator getColumnComparator(int column) {
        TableColumn tableColumn = this.getColumn(column);
        Comparator comparator = tableColumn.getComparator();
        if (comparator == null && (comparator = this.getDefaultColumnComparator(this.getColumnClass(column))) == null) {
            return this.defaultComparator;
        }
        return comparator;
    }

    public Comparator getDefaultColumnComparator(Class columnClass) {
        if (columnClass == null) {
            return null;
        }
        Object comparator = this.defaultTableColumnComparators.get(columnClass);
        if (comparator != null) {
            return (Comparator)comparator;
        }
        return this.getDefaultColumnComparator(columnClass.getSuperclass());
    }

    public void setDefaultColumnComparator(Comparator comparator) {
        this.setDefaultColumnComparator(Object.class, comparator);
    }

    public void setDefaultColumnComparator(Class columnClass, Comparator comparator) {
        this.defaultTableColumnComparators.put(columnClass, comparator);
    }

    public int getColumnCount() {
        return this.dataModel != null ? this.dataModel.getColumnCount() : 0;
    }

    public int getRowCount() {
        return this.getActiveModel().getRowCount();
    }

    public Object getValue(int row, int column) {
        ITableModel activeModel = this.getActiveModel();
        return activeModel != null ? activeModel.getValueAt(row, column) : "?";
    }

    public void setValue(int x, int y, Object value) {
        if (this.dataModel != null) {
            this.dataModel.setValueAt(value, x, y);
        }
    }

    public Class getColumnClass(int col) {
        return this.dataModel.getColumnClass(this.convertColumnIndexToModel(col));
    }

    public int convertColumnIndexToModel(int viewColumnIndex) {
        if (viewColumnIndex < 0) {
            return viewColumnIndex;
        }
        return this.getColumn(viewColumnIndex).getModelIndex();
    }

    public void setSortable(boolean sortable) {
        this.setSortable(sortable, false);
    }

    public void setSortable(boolean sortable, boolean threeStage) {
        this.setSortable(sortable, threeStage, 0, -1);
    }

    public void setSortable(boolean sortable, boolean threeStage, int startIdx) {
        this.setSortable(sortable, threeStage, startIdx, -1);
    }

    public void setSortable(boolean sortable, boolean threeStage, int startIdx, int endIdx) {
        this.sortable = sortable;
        this.sortFromIdx = startIdx;
        this.sortToIdx = endIdx;
        TableColumnModel columnModel = this.getColumnModel();
        if (columnModel != null) {
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setSortable(sortable, threeStage);
            }
        }
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public int getSortFromIdx() {
        return this.sortFromIdx < this.getRowCount() ? this.sortFromIdx : 0;
    }

    public int getSortToIdx() {
        return this.sortToIdx > 0 ? this.sortToIdx : this.getRowCount();
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    private void setSortedColumn() throws J2HTMLException {
        JSONObject sortObj;
        IEnvironment env;
        IContext context = this.getContext();
        if (context != null && (env = this.getContext().getEnv()) != null && (sortObj = (JSONObject)context.getClientStateParameter(null, "sort")) != null) {
            String order;
            int column = ((Long)sortObj.get((Object)"column")).intValue();
            if (column >= this.getColumnCount()) {
                column = 0;
            }
            this.setSortedColumn(column, !(order = (String)sortObj.get((Object)"order")).equals("default"), order.equals("ascending"));
        }
    }

    public void setSortedColumn(int column, boolean sorted, boolean ascending) {
        TableColumn sortColumn = this.getColumn(column);
        if (sortColumn != null) {
            this.clearSortedColumn();
            sortColumn.setSorted(sorted, ascending);
        }
    }

    private void clearSortedColumn() {
        for (int colCount = 0; colCount < this.getColumnCount(); ++colCount) {
            TableColumn currentColumn = this.getColumn(colCount);
            if (!currentColumn.isSortable() || !currentColumn.isSorted()) continue;
            currentColumn.setSorted(false, true);
            break;
        }
    }

    private void renderModelMarkup(XMLStreamWriter staxWriter) throws J2HTMLException {
        try {
            if (this.getActiveModel() != null) {
                JSONArray grpActionRows = (JSONArray)this.getContext().getClientStateParameter(this, CLIENTSTATE_GROUP_ACTION_ROWS);
                if (this.getTableHeader().isCollapsable()) {
                    this.idx = this.isSubTable() ? ((Table)this.getParent()).getComponentIndex(this) + 1 : 1;
                }
                int colCount = this.getColumnCount();
                this.renderRowSeparator(staxWriter, true, colCount, "#ffffff");
                if (this.getRowCount() == 0 && this.displayEmptyTableText) {
                    staxWriter.writeStartElement("tr");
                    if (this.getTableHeader().isCollapsable() && this.isSubTable()) {
                        staxWriter.writeAttribute("id", this.getContext().getUniqueID() + "_toggle_" + this.idx + "_1");
                    }
                    this.writeAttributes(staxWriter, true);
                    staxWriter.writeStartElement("td");
                    staxWriter.writeAttribute("class", "cogstyle-table-text cogstyle-table-empty");
                    staxWriter.writeAttribute("colspan", Integer.toString(colCount * 2));
                    staxWriter.writeCharacters(MessagesManagerFacade.getInstance().getMessage(this.getContext().getEnv().getProductLocale(), "IDS_PAGER_ITEMS_FOUND"));
                    staxWriter.writeEndElement();
                    staxWriter.writeEndElement();
                }
                CheckBox checkBox = new CheckBox();
                String listViewSeparator = this.getContext().getEnv().getPreference("listViewSeparator");
                Attributes rowAttributes = new Attributes();
                Attributes defaultRowAttributes = new Attributes();
                for (int row = 0; row < this.getRowCount(); ++row) {
                    staxWriter.writeStartElement("tr");
                    if (this.tableRowRenderer != null) {
                        AbstractAction action;
                        this.tableRowRenderer.init(this, row);
                        rowAttributes = this.tableRowRenderer.getRowAttributes();
                        if (rowAttributes == null) {
                            rowAttributes = defaultRowAttributes;
                        }
                        if (this.tableRowRenderer.getTableRowSeparator(false) != null) {
                            staxWriter.writeAttribute("role", "separator");
                            staxWriter.writeStartElement("td");
                            staxWriter.writeAttribute("colspan", Integer.toString(colCount * 2 - 1));
                            StringBuffer style = new StringBuffer("height:1px;padding:0;margin:0;white-space: nowrap;");
                            if (this.tableRowRenderer.getTableRowSeparator(false).isSolid()) {
                                style.append(";background-color:#cccccc;border:1px");
                            }
                            staxWriter.writeAttribute("style", style.toString());
                            staxWriter.writeEndElement();
                            staxWriter.writeEndElement();
                            staxWriter.writeStartElement("tr");
                        }
                        if ((action = this.tableRowRenderer.getSelectionAction()) != null) {
                            rowAttributes.setAttribute("cogtype", action.getCogType());
                            rowAttributes.setAttribute("cogparam", action.getCogParam().toString());
                        }
                        this.selectedRowStateKey = this.tableRowRenderer.getSelectedRowStateKey();
                        if (this.selectedRowStateKey != null) {
                            rowAttributes.setAttribute("key", this.selectedRowStateKey);
                        }
                    }
                    if (this.getTableHeader().isCollapsable()) {
                        String rowId = this.getContext().getUniqueID() + this.getTableIdx() + "_row_" + this.idx + "_" + (row + 1);
                        rowAttributes.setAttribute("id", rowId);
                        if (!this.getTableHeader().isExpanded()) {
                            this.setStyle("display", "none");
                        }
                    }
                    String className = "class";
                    if (this.isRowSelected(row)) {
                        rowAttributes.setAttribute("class", "cogstyle-table-row-selected");
                        className = "origclass";
                    }
                    if (this.supportsListViewSeparatorPreference && "background".equals(listViewSeparator)) {
                        if (row % 2 != 0) {
                            rowAttributes.setAttribute(className, "cogstyle-table-row-alternate");
                        } else {
                            rowAttributes.setAttribute(className, "cogstyle-table-row-default");
                        }
                    } else {
                        rowAttributes.setAttribute(className, "cogstyle-table-row-default");
                    }
                    rowAttributes.writeAttributes(staxWriter, true);
                    if (this.getTableHeader().isCollapsable()) {
                        staxWriter.writeEmptyElement("td");
                    }
                    CheckBoxTogglerAction defaultTogglerAction = new CheckBoxTogglerAction("checkbox_toggle");
                    for (int col = 0; col < colCount; ++col) {
                        TableColumn tableColumn = this.getColumn(col);
                        if (tableColumn == null || !tableColumn.isVisible()) continue;
                        int columnModelIdx = tableColumn.getModelIndex();
                        ITableCellRenderer renderer = this.getTableCellRenderer(row, columnModelIdx);
                        Object value = this.getActiveModel().getValueAt(row, columnModelIdx);
                        Component component = renderer.getTableCellRendererComponent(this, value, this.isRowSelected(row), false, row, columnModelIdx);
                        if (col > 0) {
                            this.renderColSeparator(staxWriter, false, this.getContext(), false);
                        }
                        if (this.supportsGroupActions() && col == 0) {
                            staxWriter.writeStartElement("td");
                            staxWriter.writeAttribute("class", "cogstyle-table-row-default");
                            staxWriter.writeAttribute("nowrap", "");
                            staxWriter.writeAttribute("headers", "_THIS_table_checkbox");
                            if (this.tableRowRenderer != null && this.tableRowRenderer.getGroupActionKey() != null) {
                                if (!this.displayGroupActions) {
                                    checkBox.setVisible(false);
                                }
                                checkBox.setID("table_checkbox_" + row);
                                checkBox.setContext(this.getContext());
                                if (this.tableRowRenderer.getGroupActionKey() != null) {
                                    checkBox.setAttribute("value", this.tableRowRenderer.getGroupActionKey());
                                }
                                if (this.tableRowRenderer.getGroupAction() != null) {
                                    checkBox.setAction(this.tableRowRenderer.getGroupAction());
                                } else {
                                    checkBox.setAction(defaultTogglerAction);
                                }
                                if (grpActionRows != null && this.selectedRowStateKey != null && JSONUtils.indexOfArray(grpActionRows, this.selectedRowStateKey) > -1) {
                                    checkBox.setChecked(true);
                                } else {
                                    checkBox.setChecked(false);
                                }
                                checkBox.setToolTip(MessagesManagerFacade.getInstance().getMessage(this.getContext().getEnv().getProductLocale(), "IDS_TABLE_SELECT", (Object[])new String[]{value.toString()}));
                                checkBox.init();
                                checkBox.writeMarkup(staxWriter);
                            }
                            staxWriter.writeEndElement();
                            this.renderColSeparator(staxWriter, false, this.getContext(), false);
                        }
                        staxWriter.writeStartElement("td");
                        this.getColumn(col).writeAttributes(this, staxWriter);
                        staxWriter.writeAttribute("nowrap", "");
                        if (component != null && component.isRenderable()) {
                            component.setContext(this.getContext());
                            component.init();
                            component.writeMarkup(staxWriter);
                        }
                        staxWriter.writeEndElement();
                    }
                    staxWriter.writeEndElement();
                    if (this.tableRowRenderer != null) {
                        if (this.tableRowRenderer.getTableRowSeparator(true) != null) {
                            this.renderRowSeparator(staxWriter, this.tableRowRenderer.getTableRowSeparator(true).isSolid(), colCount, "#cccccc");
                            continue;
                        }
                        if (!this.supportsListViewSeparatorPreference || !"line".equals(listViewSeparator)) continue;
                        this.renderRowSeparator(staxWriter, true, colCount, "#cccccc");
                        continue;
                    }
                    if (!this.supportsListViewSeparatorPreference || !"line".equals(listViewSeparator)) continue;
                    this.renderRowSeparator(staxWriter, true, colCount, "#cccccc");
                }
            }
        }
        catch (Exception e) {
            throw new J2HTMLException(e);
        }
    }

    private void renderRowSeparator(XMLStreamWriter staxWriter, boolean isSolid, int colCount, String colour) throws XMLStreamException {
        staxWriter.writeStartElement("tr");
        staxWriter.writeAttribute("role", "separator");
        staxWriter.writeStartElement("td");
        int actualColCount = this.supportsGroupActions ? colCount + 1 : colCount;
        int colSpan = 2 * actualColCount - 1;
        staxWriter.writeAttribute("colspan", Integer.toString(colSpan));
        StringBuffer style = new StringBuffer("height:1px;padding:0;margin:0");
        if (isSolid) {
            style.append(";background-color:").append(colour).append(";border:1px");
        }
        staxWriter.writeAttribute("style", style.toString());
        staxWriter.writeEndElement();
        staxWriter.writeEndElement();
    }

    protected void renderColSeparator(XMLStreamWriter staxWriter, boolean bVisible, IContext context, boolean bInHeader) throws XMLStreamException, J2HTMLException {
        staxWriter.writeStartElement(bInHeader ? "th" : "td");
        staxWriter.writeAttribute("role", "separator");
        staxWriter.writeAttribute("height", "15");
        staxWriter.writeAttribute("width", "1");
        if (bInHeader) {
            staxWriter.writeAttribute("scope", "col");
        }
        if (bVisible) {
            this.colSeparatorImg.setContext(context);
            this.colSeparatorImg.writeMarkup(staxWriter);
        }
        staxWriter.writeEndElement();
    }

    public ISortFilterTableModel getSortFilterTableModel() {
        if (this.sortFilterModel == null) {
            DefaultSortFilterTableModel sortModel = new DefaultSortFilterTableModel(this);
            sortModel.setSummary(this.getActiveModel().getSummary());
            this.setSortFilterTableModel(sortModel);
        }
        return this.sortFilterModel;
    }

    public void setSortFilterTableModel(ISortFilterTableModel sortFilterTableModel) {
        this.sortFilterModel = sortFilterTableModel;
    }

    public void setDisplayEmptyTableText(boolean display) {
        this.displayEmptyTableText = display;
    }

    private void setSubTable(boolean isSubTable) {
        this.subTable = isSubTable;
        this.getTableHeader().setSubHeader(isSubTable);
    }

    public boolean isSubTable() {
        return this.subTable;
    }

    public void addSubTable(Table subTable, int index) {
        this.add(subTable, index);
    }

    public void addSubTable(Table subTable) {
        this.add(subTable);
    }

    public void addSubTables(Table[] tables) {
        this.addAll(tables);
    }

    public ITableModel[] getSubTableModels() {
        ITableModel[] models = new ITableModel[this.getComponentCount()];
        for (int i = 0; i < this.getComponentCount(); ++i) {
            models[i] = ((Table)this.getComponent(i)).getModel();
        }
        return models;
    }

    private void initSubTables() throws J2HTMLException {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Table subTable = (Table)this.getComponent(i);
            subTable.setSubTable(true);
            subTable.setSortable(this.isSortable());
            subTable.setFilterable(this.isFilterable());
            subTable.getTableHeader();
            subTable.setColumnModel(this.getColumnModel());
            subTable.getTableHeader().setCollapsable(this.getTableHeader().isCollapsable());
            Iterator iter = this.getAttributeNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                subTable.setAttribute(name, this.getAttribute(name));
            }
            subTable.getTableHeader().setTogglerId(this.getTableIdx() + "_toggle", i + 1);
        }
    }

    private void setDefaultAttributes() {
        this.setSortable(false);
        this.filterable = false;
        this.displayEmptyTableText = true;
        this.setWidth("100%");
    }

    public void setRowRenderer(ITableRowRenderer tableRowRenderer) {
        this.tableRowRenderer = tableRowRenderer;
    }

    public ITableRowRenderer getRowRenderer() {
        return this.tableRowRenderer;
    }

    public boolean supportsGroupActions() {
        return this.supportsGroupActions;
    }

    public boolean displayGroupActions() {
        return this.displayGroupActions;
    }

    public void setSupportsGroupActions(boolean supportsGroupActions) {
        this.setSupportsGroupActions(supportsGroupActions, true);
    }

    public void setSupportsGroupActions(boolean supportsGroupActions, boolean display) {
        this.setSupportsGroupActions(supportsGroupActions, display, false);
    }

    public void setSupportsGroupActions(boolean supportsGroupActions, boolean display, boolean persist) {
        this.supportsGroupActions = supportsGroupActions;
        this.displayGroupActions = display;
        this.persistGroupActions = persist;
    }

    public void setSupportsListViewSeparatorPreference(boolean supportsListViewSeparatorPreference) {
        this.supportsListViewSeparatorPreference = supportsListViewSeparatorPreference;
    }

    public boolean supportsListViewSeparatorPreference() {
        return this.supportsListViewSeparatorPreference;
    }

    @Override
    public String[] getSkipPersistClientState() {
        String[] stringArray;
        if (this.persistGroupActions) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = CLIENTSTATE_GROUP_ACTION_ROWS;
        }
        return stringArray;
    }
}

