/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.DefaultTableCellRenderer;
import com.cognos.admin.j2html.TableLayoutConstraint;
import com.cognos.admin.j2html.common.ReflectionUtils;
import com.cognos.admin.j2html.common.logging.J2HTMLLogger;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.TableColumnFilter;
import java.util.Comparator;

public class TableColumn
extends TableLayoutConstraint {
    private static final String HIDDEN_CELL_RENDERER_KEY = "HIDE";
    private int modelIndex;
    private Object headerValue;
    private Object footerValue;
    private ITableCellRenderer cellRenderer;
    private ITableCellRenderer headerRenderer;
    private ITableCellRenderer footerRenderer;
    private boolean sortable = false;
    private boolean sorted = false;
    private boolean ascending = false;
    private boolean visible = true;
    private Comparator comparator;
    private TableColumnFilter filter;
    private boolean wordWrap = false;
    private boolean threeStageSort = false;

    public TableColumn(int modelIndex) {
        this(modelIndex, new DefaultTableCellRenderer());
    }

    public TableColumn(int modelIndex, ITableCellRenderer cellRenderer) {
        this.modelIndex = modelIndex;
        this.cellRenderer = this.headerRenderer;
    }

    public void setHeaderValue(Object headerValue) {
        this.headerValue = headerValue;
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public void setFooterValue(Object headerValue) {
        this.footerValue = headerValue;
    }

    public Object getFooterValue() {
        return this.footerValue == null ? "" : this.footerValue;
    }

    public void setHeaderRenderer(ITableCellRenderer headerRenderer) {
        this.headerRenderer = headerRenderer;
    }

    public ITableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setFooterRenderer(ITableCellRenderer footerRenderer) {
        this.footerRenderer = footerRenderer;
    }

    public ITableCellRenderer getFooterRenderer() {
        return this.footerRenderer;
    }

    public void setCellRenderer(ITableCellRenderer renderer) {
        this.cellRenderer = renderer;
    }

    public void setCellRenderer(String rendererClassName) {
        if (rendererClassName != null) {
            if (rendererClassName.equalsIgnoreCase(HIDDEN_CELL_RENDERER_KEY)) {
                this.setVisible(false);
            } else {
                try {
                    this.setCellRenderer((ITableCellRenderer)ReflectionUtils.newInstance(rendererClassName, ITableCellRenderer.class));
                }
                catch (Exception e) {
                    J2HTMLLogger.getInstance().error("A reflection error occured trying to instantiate a " + ITableCellRenderer.class.getName() + " renderer for class: " + rendererClassName, e);
                }
            }
        }
    }

    public ITableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    public void setSortable(boolean sortable) {
        this.setSortable(sortable, false);
    }

    public boolean isThreeStageSort() {
        return this.threeStageSort;
    }

    public void setThreeStageSort(boolean threeStageSort) {
        this.threeStageSort = threeStageSort;
    }

    public void setSortable(boolean sortable, boolean threeStage) {
        this.sortable = sortable;
        this.threeStageSort = threeStage;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    void setSorted(boolean sorted, boolean ascending) {
        this.setSortable(true, this.threeStageSort);
        this.sorted = sorted;
        this.ascending = ascending;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public TableColumnFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TableColumnFilter filter) {
        this.filter = filter;
    }

    public void setWhiteSpaceWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
    }

    public boolean isWhiteSpaceWordWrap() {
        return this.wordWrap;
    }
}

