/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.Table;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.TableColumnModel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class TableFooter
extends Component {
    private TableColumnModel columnModel;
    private Table table;

    public TableFooter(Table table) {
        this.table = table;
        this.columnModel = table.getColumnModel();
        this.setRenderable(false);
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        this.writeAttributes(staxWriter);
        staxWriter.writeStartElement("tr");
        for (int col = 0; col < this.columnModel.getColumnCount(); ++col) {
            ITableCellRenderer renderer;
            TableColumn tableColumn = this.columnModel.getColumn(col);
            Object value = tableColumn.getFooterValue();
            if (!tableColumn.isVisible() || (renderer = tableColumn.getFooterRenderer()) == null) continue;
            staxWriter.writeStartElement("td");
            staxWriter.writeAttribute("nowrap", "");
            staxWriter.writeAttribute("colspan", Integer.toString(2 * this.table.getColumnCount() + 1));
            int columnModelIdx = tableColumn.getModelIndex();
            Component columnComponent = renderer.getTableCellRendererComponent(this.table, value, false, false, 0, columnModelIdx);
            tableColumn.writeAttributes(this.table, staxWriter);
            columnComponent.setContext(this.getContext());
            columnComponent.writeMarkup(staxWriter);
            staxWriter.writeEndElement();
        }
        staxWriter.writeEndElement();
    }
}

