/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.CheckBox;
import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.Image;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.SkinImage;
import com.cognos.admin.j2html.Table;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.actions.AbstractAction;
import com.cognos.admin.j2html.actions.ActionImpl;
import com.cognos.admin.j2html.actions.CheckBoxTogglerAction;
import com.cognos.admin.j2html.actions.IAction;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.TableColumnModel;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class TableHeader
extends Component {
    private TableColumnModel columnModel;
    private Table table;
    private SkinImage sortImage = new SkinImage();
    private boolean subHeader = false;
    private boolean collapsable = false;
    private Image toggler;
    private boolean expanded = false;
    private ITableCellRenderer defaultRenderer = null;
    private static final String IMG_SORT_ASCENDING = "/portal/images/list_sort_ascending.gif";
    private static final String IMG_SORT_DESCENDING = "/portal/images/list_sort_descending.gif";
    private static final String IMG_SORT_NONE = "/portal/images/list_sort_no.gif";

    public TableHeader(Table table) {
        this.table = table;
        this.setContext(table.getContext());
        this.columnModel = table.getColumnModel();
        if (this.columnModel == null) {
            table.createDefaultColumnsFromModel();
            this.columnModel = table.getColumnModel();
        }
        this.setStyle("background-color", "#99aacc");
        this.sortImage.setVerticalAlign("top");
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        this.sortImage.setContext(this.getContext());
        if (!this.subHeader) {
            staxWriter.writeStartElement("thead");
            staxWriter.writeAttribute("class", "cogstyle-table-header");
            this.writeAttributes(staxWriter);
        }
        staxWriter.writeStartElement("tr");
        if (this.collapsable) {
            this.toggler.setContext(this.getContext());
            if (this.toggler.getID() != null) {
                staxWriter.writeAttribute("id", this.toggler.getID().replaceFirst("toggle", "row"));
            }
        }
        if (this.subHeader) {
            staxWriter.writeAttribute("class", "cogstyle-table-group");
        }
        if (this.collapsable) {
            staxWriter.writeStartElement("th");
            staxWriter.writeAttribute("width", "16px");
            if (this.toggler.getID() == null) {
                this.setTogglerId(Integer.toString(this.table.getTableIdx()), 1);
            }
            this.toggler.setRelativePath("/ps/cogadmin/images/" + (this.expanded ? "collapse" : "expand") + ".gif");
            this.toggler.writeMarkup(staxWriter);
            staxWriter.writeEndElement();
        }
        if (this.table.supportsGroupActions()) {
            CheckBox checkBox = new CheckBox();
            checkBox.setContext(this.getContext());
            checkBox.setID("table_checkbox");
            checkBox.setAttribute("scope", "column");
            checkBox.setToolTip(this.table.getContext().localize("IDS_TABLE_SELECT_ALL"));
            staxWriter.writeStartElement("th");
            staxWriter.writeAttribute("nowrap", "");
            staxWriter.writeAttribute("width", "15px");
            if (this.table.getRowRenderer() != null) {
                AbstractAction action = this.table.getRowRenderer().getGroupAction();
                if (action == null) {
                    action = new CheckBoxTogglerAction(null);
                }
                checkBox.setAction(action);
                checkBox.init();
            }
            checkBox.writeMarkup(staxWriter);
            staxWriter.writeEndElement();
            this.table.renderColSeparator(staxWriter, true, this.getContext(), true);
        }
        for (int col = 0; col < this.columnModel.getColumnCount(); ++col) {
            TableColumn tableColumn = this.columnModel.getColumn(col);
            int columnModelIdx = tableColumn.getModelIndex();
            TableColumn column = this.columnModel.getColumn(columnModelIdx);
            if (!tableColumn.isVisible()) continue;
            Component columnComponent = null;
            ITableCellRenderer renderer = tableColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.defaultRenderer;
            }
            if (renderer != null) {
                columnComponent = renderer.getTableCellRendererComponent(this.table, column.getHeaderValue(), false, false, 0, columnModelIdx);
            }
            if (col > 0) {
                this.table.renderColSeparator(staxWriter, true, this.getContext(), true);
            }
            staxWriter.writeStartElement("th");
            staxWriter.writeAttribute("nowrap", "");
            staxWriter.writeAttribute("scope", "col");
            column.writeAttributes(this.table, staxWriter);
            col += column.getColumnSpan() - 1;
            if (columnComponent != null) {
                columnComponent.init();
                staxWriter.writeStartElement("table");
                staxWriter.writeAttribute("role", "presentation");
                staxWriter.writeStartElement("tr");
                staxWriter.writeStartElement("td");
                String tdStyle = "padding:0 0 0 0";
                if (column.isWhiteSpaceWordWrap()) {
                    tdStyle = tdStyle + ";white-space:pre-wrap;white-space:-moz-pre-wrap;word-wrap:break-word;";
                }
                staxWriter.writeAttribute("style", tdStyle);
                staxWriter.writeAttribute("class", "cogstyle-table-group-title");
                String toolTip = column.getToolTip();
                if (toolTip != null) {
                    staxWriter.writeAttribute("title", toolTip);
                }
                columnComponent.setContext(this.getContext());
                columnComponent.writeMarkup(staxWriter);
                staxWriter.writeEndElement();
                if (column.isSortable() && !this.isSubHeader()) {
                    IAction sortAction = this.getColumnSortAction(column);
                    staxWriter.writeStartElement("td");
                    if (sortAction != null) {
                        if (column.isSorted()) {
                            if (column.isAscending()) {
                                this.sortImage.setPath(IMG_SORT_ASCENDING, false);
                            } else {
                                this.sortImage.setPath(IMG_SORT_DESCENDING, false);
                            }
                        } else {
                            this.sortImage.setPath(IMG_SORT_NONE, false);
                        }
                        this.sortImage.setAction(sortAction);
                        this.sortImage.setBorder("0pt none");
                        this.sortImage.setVerticalAlign("bottom");
                        this.sortImage.supportTabbing(true);
                        this.sortImage.init();
                        this.sortImage.writeMarkup(staxWriter);
                    }
                    staxWriter.writeEndElement();
                }
                staxWriter.writeEndElement();
                staxWriter.writeEndElement();
            }
            staxWriter.writeEndElement();
        }
        staxWriter.writeEndElement();
        if (!this.subHeader) {
            staxWriter.writeEndElement();
        }
    }

    public void setSubHeader(boolean subHeader) {
        this.subHeader = subHeader;
    }

    public boolean isSubHeader() {
        return this.subHeader;
    }

    public void setCollapsable(boolean collapsable) {
        this.collapsable = collapsable;
        this.toggler = new Image();
    }

    private void setExpanded(boolean isExpanded) {
        this.expanded = isExpanded;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    public void setTogglerId(String id, int idx) throws J2HTMLException {
        if (this.toggler != null) {
            id = this.getContext().getUniqueID() + id;
            this.toggler.setID(this.subHeader ? id + "_" + idx : id);
            this.toggler.setAction(new ActionImpl(){

                @Override
                public String getCogType() {
                    return TableHeader.this.subHeader ? "toggler" : "all_toggler";
                }
            });
            JSONArray expandedGrps = (JSONArray)this.getContext().getClientStateParameter(this.table, "expandrows");
            if (expandedGrps != null) {
                for (int i = 0; i < expandedGrps.size(); ++i) {
                    if (!new StringBuffer(this.getContext().getUniqueID()).append(this.table.getTableIdx()).append("_row_").append(idx).toString().equals(expandedGrps.get(i))) continue;
                    this.setExpanded(true);
                    return;
                }
            }
        }
    }

    public String getTogglerId() {
        return this.toggler.getID();
    }

    public void setWhiteSpaceWordWrap(boolean wordWrap) {
        for (int col = 0; col < this.columnModel.getColumnCount(); ++col) {
            TableColumn tableColumn = this.columnModel.getColumn(col);
            tableColumn.setWhiteSpaceWordWrap(wordWrap);
        }
    }

    public boolean isCollapsable() {
        return this.collapsable;
    }

    public void setDefaultRenderer(ITableCellRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }

    protected IAction getColumnSortAction(TableColumn column) throws J2HTMLException {
        return new ColumnSortAction(column);
    }

    private class ColumnSortAction
    implements IAction {
        TableColumn column = null;

        public ColumnSortAction(TableColumn column) {
            this.column = column;
        }

        @Override
        public String getActionType() {
            return null;
        }

        @Override
        public String getCogType() {
            return "sort_column";
        }

        public boolean isDisabled() {
            return this.column.isThreeStageSort() && this.column.isSorted() && !this.column.isAscending();
        }

        @Override
        public JSONObject getCogParam() throws J2HTMLException {
            JSONObject cogParam = new JSONObject();
            cogParam.put((Object)"column", (Object)this.column.getModelIndex());
            cogParam.put((Object)"order", (Object)(this.isDisabled() ? "default" : (this.column.isAscending() ? "descending" : "ascending")));
            return cogParam;
        }
    }
}

