/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.Attributes;
import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.Table;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class TableLayoutConstraint
extends Attributes {
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_RIGHT = "right";
    public static final String ALIGN_CENTER = "center";
    public static final int INDENTATION_MULTIPLE = 20;
    private int indent = 0;
    private int colspan = 1;

    public void setRowSpan(int rows) {
        this.setAttribute("rowspan", rows);
    }

    @Override
    public void setPadding(String padding) {
        this.setStyle("padding", padding);
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public void setWordWrap(boolean wordWrap) {
        if (!wordWrap) {
            this.setStyle("white-space", "nowrap");
        } else {
            this.removeStyle("white-space");
        }
    }

    public void indent(int depth) {
        this.setIndentation(this.indent + depth);
    }

    public void indent() {
        this.indent(1);
    }

    public void setIndentation(int indentation) {
        if (indentation >= 0) {
            this.indent = indentation;
        }
    }

    public void setColumnSpan(int colspan) {
        this.colspan = colspan;
    }

    public int getColumnSpan() {
        return this.colspan;
    }

    void setAttribute(String name, int value) {
        this.setAttribute(name, Integer.toString(value));
    }

    void setStyle(String name, int value) {
        this.setStyle(name, Integer.toString(value));
    }

    void writeAttributes(Table table, XMLStreamWriter writer) throws XMLStreamException {
        if (this.indent > 0) {
            this.setStyle("padding-left", Component.px(this.indent * 20));
        } else {
            this.removeStyle("padding-left");
        }
        int _colSpan = this.getColumnSpan();
        if (_colSpan > 1) {
            if (table != null) {
                _colSpan = 2 * _colSpan - 1;
                if (table.supportsGroupActions()) {
                    _colSpan += 2;
                }
            }
            this.setAttribute("colspan", _colSpan);
        } else {
            this.removeAttribute("colspan");
        }
        super.writeAttributes(writer);
    }

    @Override
    void writeAttributes(XMLStreamWriter writer) throws XMLStreamException {
        this.writeAttributes(null, writer);
    }
}

