/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.Attributes;
import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.ITableLayoutHandler;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.TableLayoutConstraint;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class TableLayoutPane
extends Component {
    private int numColumns = 0;
    private int numRows = 0;
    Attributes tableAttributes = new Attributes();
    private ITableLayoutHandler layoutHandler = null;

    public TableLayoutPane(int numRows, int numColumns) {
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.tableAttributes.setAttribute("role", "presentation");
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public void setCellSpacing(int cellSpacing) {
        this.tableAttributes.setAttribute("cellspacing", Integer.toString(cellSpacing));
    }

    public void setCellPadding(int cellPadding) {
        this.tableAttributes.setAttribute("cellpadding", Integer.toString(cellPadding));
    }

    @Override
    public void setWidth(String width) {
        this.tableAttributes.setAttribute("width", width);
    }

    @Override
    public void writeMarkup(XMLStreamWriter staxWriter) throws XMLStreamException, J2HTMLException {
        staxWriter.writeStartElement("table");
        this.tableAttributes.writeAttributes(staxWriter);
        for (int rowIdx = 0; rowIdx < this.numRows; ++rowIdx) {
            staxWriter.writeStartElement("tr");
            this.renderRow(staxWriter, rowIdx);
            staxWriter.writeEndElement();
        }
        staxWriter.writeEndElement();
    }

    public ITableLayoutHandler getLayoutHandler() {
        return this.layoutHandler;
    }

    private void renderRow(XMLStreamWriter staxWriter, int rowIdx) throws XMLStreamException, J2HTMLException {
        for (int colIdx = 0; colIdx < this.numColumns; ++colIdx) {
            Component comp;
            staxWriter.writeStartElement("td");
            TableLayoutConstraint tlc = this.layoutHandler.getTableLayoutConstaint(rowIdx, colIdx);
            if (tlc != null) {
                tlc.writeAttributes(staxWriter);
            }
            if ((comp = this.layoutHandler.getTableLayoutComponent(rowIdx, colIdx)) != null) {
                comp.setContext(this.getContext());
                comp.init();
                comp.parent = this.getParent();
                comp.writeMarkup(staxWriter);
            }
            staxWriter.writeEndElement();
        }
    }

    public void setTableLayoutHandler(ITableLayoutHandler layoutHandler) {
        this.layoutHandler = layoutHandler;
    }

    @Override
    public String[] getSkipPersistClientState() {
        ArrayList<String> aPersists = new ArrayList<String>();
        for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < this.numColumns; ++col) {
                String[] _tmpPersists;
                Component comp = this.layoutHandler.getTableLayoutComponent(row, col);
                if (comp == null || (_tmpPersists = comp.getSkipPersistClientState()) == null) continue;
                for (int i = 0; i < _tmpPersists.length; ++i) {
                    aPersists.add(_tmpPersists[i]);
                }
            }
        }
        if (aPersists.size() > 0) {
            String[] persists = new String[aPersists.size()];
            for (int i = 0; i < aPersists.size(); ++i) {
                persists[i] = aPersists.get(i).toString();
            }
            return persists;
        }
        return null;
    }
}

