/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html;

import com.cognos.admin.j2html.IToggleState;
import com.cognos.admin.j2html.IToggleStateModel;
import com.cognos.admin.j2html.Image;

public class ToggleButton
extends Image {
    public ToggleButton(IToggleStateModel model) {
        if (model == null) {
            throw new IllegalArgumentException("IToggleStateModel cannot be null");
        }
        this.setCurrentState(model.getDefaultState());
        this.setAttribute("role", "checkbox");
    }

    public void setCurrentState(IToggleState currentState) {
        String stateValue = currentState.getStateValue();
        this.setAttribute("state", stateValue);
        super.setRelativePath(currentState.getImagePath());
        if (stateValue == "disabled") {
            this.setAccesssible(Boolean.FALSE);
            this.setDisabled(Boolean.TRUE);
            this.setAttribute("aria-checked", "undefined");
        } else {
            this.setAccesssible(Boolean.TRUE);
            this.setDisabled(Boolean.FALSE);
            this.setAttribute("aria-checked", stateValue);
        }
    }

    @Override
    public void setRelativePath(String path) {
        throw new UnsupportedOperationException("The image is supplied by the constructor's IToggleStateModel");
    }
}

