/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html.actions;

import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.actions.IAction;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AbstractAction
implements IAction {
    public static final String COGTYPE_ACTION = "action";
    public static final String PROMPT_TYPE_MESSAGE = "message";
    public static final String PROMPT_TYPE_CONFIRM = "confirm";
    public static final String PROMPT_MESSAGETYPE_QUESTION = "question";
    public static final String PROMPT_MESSAGETYPE_ERROR = "error";
    public static final String PROMPT_MESSAGETYPE_INFO = "info";
    public static final String PROMPT_MESSAGETYPE_WARNING = "warn";
    public static final String PROMPT_MESSAGETYPE_PLAIN = "plain";
    public static final String EVENT_KEY_SPACE = "SPACE";
    public static final String EVENT_KEY_ENTER = "ENTER";
    private static final ArrayList PROMPTTYPE_LIST = new ArrayList();
    private boolean isGroupAction;
    protected JSONObject markup;
    private Prompt prompt;
    private boolean propogateEvent = false;
    private String eventKey = null;

    public AbstractAction() {
        this(false);
    }

    public AbstractAction(boolean isGroupAction) {
        this.setGroupAction(isGroupAction);
    }

    public void setGroupAction(boolean isGroupAction) {
        this.isGroupAction = isGroupAction;
    }

    public boolean isGroupAction() {
        return this.isGroupAction;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    @Override
    public JSONObject getCogParam() throws J2HTMLException {
        JSONObject action;
        JSONObject cogParam = new JSONObject();
        cogParam.put((Object)"actionType", (Object)this.getActionType());
        cogParam.put((Object)"stopPropagation", (Object)(!this.propogateEvent ? 1 : 0));
        if (this.eventKey != null) {
            cogParam.put((Object)"eventKey", (Object)this.eventKey);
        }
        if (this.isGroupAction()) {
            cogParam.put((Object)"grpAction", (Object)this.isGroupAction());
        }
        if (this.prompt != null) {
            cogParam.put((Object)"prompt", (Object)this.prompt);
        }
        if ((action = this.getAction()) != null) {
            Iterator iter = action.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                cogParam.put((Object)key, action.get((Object)key));
            }
        }
        return cogParam;
    }

    public void setPrompt(String message) {
        this.prompt = new Prompt(PROMPT_TYPE_MESSAGE, message);
    }

    public void setPrompt(String message, String type) {
        this.prompt = new Prompt(type, message, null);
    }

    public void setPrompt(String message, String type, String messageType) {
        this.prompt = new Prompt(type, message, messageType);
    }

    @Override
    public abstract String getActionType();

    public abstract JSONObject getAction() throws J2HTMLException;

    public void setPropogateEvent(boolean propogateEvent) {
        this.propogateEvent = propogateEvent;
    }

    @Override
    public String getCogType() {
        return COGTYPE_ACTION;
    }

    static {
        PROMPTTYPE_LIST.add(PROMPT_TYPE_MESSAGE);
        PROMPTTYPE_LIST.add(PROMPT_TYPE_CONFIRM);
    }

    private class Prompt
    extends JSONObject {
        public Prompt(String type, String message) {
            this(type, message, null);
        }

        public Prompt(String type, String message, String messageType) {
            if (message == null) {
                throw new IllegalArgumentException("Message cannot be null");
            }
            this.put("text", message);
            if (!PROMPTTYPE_LIST.contains(type)) {
                throw new IllegalArgumentException("Unsupported promptType: " + type);
            }
            this.put("type", type);
        }
    }
}

