/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html.portal.producer.common;

import com.cognos.admin.j2html.common.logging.J2HTMLLogger;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.portal.producer.control.ProducerContext;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Markup;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IDelayedOutput;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.InputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ProducerUtils {
    public static final String XTSFRAGTARGET_PREFIX = "bus://xts.run?m=";

    public static void appendToMarkup(StageContext context, String markupString) {
        ProducerUtils.appendToMarkup(context, 0, markupString);
    }

    public static void appendToMarkup(StageContext context, int index, String markupString) {
        Markup markup;
        StringBuffer sbMarkupString = new StringBuffer();
        Fragment frag = context.getFragment();
        try {
            markup = frag.getMarkup(index);
        }
        catch (Exception e) {
            markup = new Markup();
            try {
                frag.setMarkup(index, markup);
            }
            catch (Exception e2) {
                frag.addMarkup(markup);
            }
        }
        String currentMarkup = markup.getMarkupString();
        if (currentMarkup != null) {
            sbMarkupString.append(currentMarkup);
        }
        markup.setMarkupString(sbMarkupString.append(markupString).toString());
    }

    public static IPipelineOutput loadXMLFileOutput(String path, boolean isLazy) throws XMLStreamException, PipelineException, FactoryConfigurationError {
        IPipelineOutput outputImpl = PipelineOutputFactory.getInstance().createOutput();
        final String _path = path;
        if (isLazy) {
            outputImpl.setDelayedOutput(new IDelayedOutput(){

                public void writeOutput(IPipelineOutput output) {
                    try {
                        ProducerUtils.loadXMLFileOutput(_path, output);
                    }
                    catch (PipelineException e) {
                        J2HTMLLogger.getInstance().error(e.getMessage(), e);
                    }
                    catch (XMLStreamException e) {
                        J2HTMLLogger.getInstance().error(e.getMessage(), e);
                    }
                    catch (FactoryConfigurationError e) {
                        J2HTMLLogger.getInstance().error(e.getMessage(), e);
                    }
                }
            });
        } else {
            ProducerUtils.loadXMLFileOutput(path, outputImpl);
        }
        return outputImpl;
    }

    private static void loadXMLFileOutput(String path, IPipelineOutput output) throws XMLStreamException, FactoryConfigurationError, PipelineException {
        XMLStreamReader staxReader = XMLStreamFactory.createXMLStreamReader((InputStream)ProducerUtils.class.getResourceAsStream(path));
        XMLStreamWriter staxWriter = output.getXMLStreamWriter();
        StaxUtils.copyCurrentElement((XMLStreamReader)staxReader, (XMLStreamWriter)staxWriter);
        staxWriter.writeEndElement();
        staxWriter.flush();
        staxWriter.close();
        staxReader.close();
    }

    public static String transientUpdate(StageContext context, String transientAttrName, String paramAttrName, String defaultValue) {
        String value = context.getEnv().getParameter(paramAttrName);
        if (value == null && (value = context.getTransientParams().getValue(transientAttrName)) == null) {
            value = defaultValue;
        }
        if (value != null) {
            String currentTransientValue = context.getTransientParams().getValue(transientAttrName);
            if (!value.equals(currentTransientValue)) {
                Fragment.TransientUpdate transientUpdate = new Fragment.TransientUpdate(context.getFragment());
                transientUpdate.setName(transientAttrName);
                transientUpdate.setScope("page");
                transientUpdate.setValue(value);
                context.getFragment().addTransientUpdate(transientUpdate);
            }
            return value;
        }
        return null;
    }

    public static String getControllerAttributeValue(StageContext context, String attrName) {
        return ProducerUtils.getControllerAttributeValue(context, attrName, attrName, attrName, null);
    }

    public static String getControllerAttributeValue(StageContext context, String attrName, String defaultValue) {
        return ProducerUtils.getControllerAttributeValue(context, attrName, attrName, attrName, defaultValue);
    }

    public static String getControllerAttributeValue(StageContext context, String paramAttrName, String stateAttrName, String transientAttrName, String defaultValue) {
        String value;
        if (stateAttrName == null) {
            stateAttrName = paramAttrName;
        }
        if (transientAttrName == null) {
            transientAttrName = paramAttrName;
        }
        if ((value = context.getEnv().getParameter(paramAttrName)) != null && value.length() > 0) {
            return value;
        }
        value = context.getStateParams().getValue(stateAttrName);
        if (value != null && value.length() > 0) {
            return value;
        }
        value = context.getTransientParams().getValue(transientAttrName);
        if (value != null && value.length() > 0) {
            return value;
        }
        return defaultValue;
    }

    public static Fragment getXTSFragment(StageContext context, String location, Parameters params) throws XMLStreamException, DashboardException {
        if (!location.startsWith(XTSFRAGTARGET_PREFIX)) {
            location = XTSFRAGTARGET_PREFIX + location;
        }
        return ProducerUtils.getFragment(context, location, params);
    }

    public static Fragment getFragment(IContext context, String location, Parameters params) throws XMLStreamException, PipelineException, LocalizableException {
        return ProducerUtils.getFragment(((ProducerContext)context).getStageContext(), location, params);
    }

    public static Fragment getFragment(StageContext context, String location) throws XMLStreamException, PipelineException, LocalizableException {
        return ProducerUtils.getFragment(context, location, null);
    }

    public static Fragment getFragment(StageContext context, String location, Parameters params) throws XMLStreamException, DashboardException {
        if (params == null) {
            params = new Parameters();
        }
        Fragment xtsFrag = new Fragment();
        XMLStreamReader fragStream = XMLStreamFactory.createXMLStreamReader((InputStream)context.getEnv().getTargetStream(location, params));
        fragStream.nextTag();
        xtsFrag.read(fragStream);
        context.getFragment().setPreferredTitle(xtsFrag.getPreferredTitle());
        return xtsFrag;
    }

    public static String addStateParameter(IContext context, String name, String[] parmNames, String defaultValue) {
        String value;
        if (name != null && (value = ProducerUtils.getParameter(context, parmNames, defaultValue)) != null) {
            context.setStateParameter(name, value);
            return value;
        }
        return null;
    }

    public static String getParameter(StageContext context, String[] parmNames, String defaultValue) {
        return ProducerUtils.getParameter(ProducerUtils.getProducerContext(context), parmNames, defaultValue);
    }

    public static String getParameter(IContext context, String[] parmNames, String defaultValue) {
        String value = null;
        if (parmNames != null) {
            for (int i = 0; i < parmNames.length && (value = context.getEnv().getParameter(parmNames[i])) == null; ++i) {
            }
        }
        return value != null ? value : defaultValue;
    }

    public static ProducerContext getProducerContext(StageContext context) {
        return new ProducerContext(context, null);
    }
}

