/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html.portal.producer.control;

import com.cognos.admin.j2html.control.IControlledComponentFactory;
import com.cognos.admin.j2html.portal.producer.control.BaseJ2htmlStage;
import com.cognos.admin.j2html.portal.producer.control.IControlledComponentFactoryProvider;
import com.cognos.admin.j2html.portal.producer.control.J2HTMLStageUtil;
import com.cognos.admin.j2html.portal.producer.control.ProducerContext;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.schemas.fragments.Css;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Library;
import com.cognos.portal.xml.pipeline.PipelineException;
import java.util.HashMap;
import javax.xml.stream.XMLStreamReader;

public abstract class J2HTMLRenderStage
extends BaseJ2htmlStage {
    private static final String[] jsLibs = new String[]{"$CGI$/messages/applications/cogadmin/messages/j2htmljsmsgs", "$WEB$/ps/j2html/js/j2html.js", "$WEB$/ps/j2html/js/util/Tools.js", "$WEB$/ps/j2html/js/util/ClientState.js", "$WEB$/ps/j2html/js/widget/Event.js", "$WEB$/ps/j2html/js/widget/Builder.js", "$WEB$/ps/j2html/js/widget/Tooltip.js"};
    private static final String[] cssLibs = new String[]{"$WEB$/skins/$SKIN$/j2html/j2html.css"};

    public J2HTMLRenderStage(ServiceLogger logger) {
        super(logger);
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        String[] readerNames = null;
        HashMap<String, XMLStreamReader> readers = null;
        ProducerContext producerContext = null;
        IControlledComponentFactory factory = null;
        Fragment frag = null;
        IControlledComponentFactoryProvider factoryProvider = null;
        try {
            frag = context.getFragment();
            this.initScripts(frag);
            this.initStyle(frag);
            if (this.isControlledComponentFactoryProvider()) {
                factoryProvider = (IControlledComponentFactoryProvider)((Object)this);
                factory = factoryProvider.getControlledComponentFactory();
                readerNames = factoryProvider.getReaderNames();
                readers = J2HTMLStageUtil.getXMLReaders(context, readerNames);
                producerContext = new ProducerContext(context, factoryProvider.getMessageManager());
                producerContext.render(factory.createControlledComponent(producerContext, readers));
            }
        }
        catch (Throwable t) {
            this.processExecutionError(t, context);
        }
    }

    @Override
    protected String getGlobalErrorId() {
        return "IDS_ERROR_IN_RENDERING_STAGE";
    }

    private boolean isControlledComponentFactoryProvider() {
        return this instanceof IControlledComponentFactoryProvider;
    }

    private void initScripts(Fragment frag) {
        int i;
        int libCount = frag.getLibraryCount();
        Library[] libs = new Library[libCount];
        for (i = 0; i < libCount; ++i) {
            libs[i] = frag.getLibrary(i);
        }
        for (i = 0; i < jsLibs.length; ++i) {
            Library lib = new Library();
            lib.setType("text/javascript");
            lib.setHref(jsLibs[i]);
            if (i < libCount) {
                frag.setLibrary(i, lib);
                continue;
            }
            frag.addLibrary(lib);
        }
        for (i = 0; i < libCount; ++i) {
            if (libCount > jsLibs.length + i) {
                frag.setLibrary(jsLibs.length + i, libs[i]);
                continue;
            }
            frag.addLibrary(libs[i]);
        }
    }

    private void initStyle(Fragment frag) {
        int i;
        int libCount = frag.getCssCount();
        Css[] libs = new Css[libCount];
        for (i = 0; i < libCount; ++i) {
            libs[i] = frag.getCss(i);
        }
        for (i = 0; i < cssLibs.length; ++i) {
            Css lib = new Css();
            lib.setType("text/css");
            lib.setHref(cssLibs[i]);
            if (i < libCount) {
                frag.setCss(i, lib);
                continue;
            }
            frag.addCss(lib);
        }
        for (i = 0; i < libCount; ++i) {
            if (libCount > cssLibs.length + i) {
                frag.setCss(cssLibs.length + i, libs[i]);
                continue;
            }
            frag.addCss(libs[i]);
        }
    }

    public boolean canShare() {
        return false;
    }
}

