/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html.portal.producer.control;

import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.ControlledComponent;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.actions.TransientUpdate;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IEnvironment;
import com.cognos.admin.j2html.control.IMessagesManager;
import com.cognos.admin.j2html.portal.producer.control.ProducerEnvironment;
import com.cognos.cps.bseries.xts.request.nav.NavException;
import com.cognos.cps.bseries.xts.request.nav.stax.BusHeader;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.schemas.AnyType;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Markup;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.portal.xml.stream.XMLStreamReaderRecorder;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ProducerContext
implements IContext {
    private StageContext context;
    private ProducerEnvironment env;
    private XMLStreamWriter staxWriter;
    private boolean clientStateInitialized = false;
    private IMessagesManager messagesMgrImpl;
    private JSONObject fragJsonClientState = null;
    private String id;
    private int nextTableIdx = 1;
    private BusHeader busHeader = null;
    private Locale productLocale = null;
    private static final String J2HTMLUISTATE_KEY = "j2html-ui-state";

    public ProducerContext(StageContext context, IMessagesManager messagesMgrImpl) {
        this.messagesMgrImpl = messagesMgrImpl;
        this.context = context;
        this.env = new ProducerEnvironment(context);
        this.id = context.getEnv().getParameter("frag-id");
        if (this.id == null) {
            this.id = "_THIS_";
        }
    }

    @Override
    public IEnvironment getEnv() {
        return this.env;
    }

    public XMLStreamWriter getStaxWriter() {
        return this.staxWriter;
    }

    @Override
    public void render(ControlledComponent component) throws XMLStreamException, J2HTMLException {
        String sWriteMarkupAsXML;
        if (this.fragJsonClientState != null) {
            this.setStateParameter(J2HTMLUISTATE_KEY, this.fragJsonClientState.toString());
        }
        boolean writeMarkupAsXML = (sWriteMarkupAsXML = this.context.getEnv().getParameter("markup")) == null || "string".equals(sWriteMarkupAsXML);
        AnyType anyType = null;
        StringWriter writer = null;
        if (writeMarkupAsXML) {
            anyType = new AnyType();
            this.staxWriter = anyType.getXMLStreamWriter();
        } else {
            writer = new StringWriter();
            this.staxWriter = XMLStreamFactory.createXMLStreamWriter((Writer)writer);
        }
        this.staxWriter.writeStartElement("div");
        component.writeMarkup(this.staxWriter);
        this.staxWriter.writeEndElement();
        this.staxWriter.close();
        Markup markup = new Markup();
        if (writeMarkupAsXML) {
            markup.setMarkupXml(anyType);
        } else {
            markup.setMarkupString(writer.getBuffer().toString());
        }
        Fragment frag = this.context.getFragment();
        frag.addMarkup(markup);
    }

    @Override
    public String getStateParameter(String name) {
        return this.context.getStateParams().getValue(name);
    }

    @Override
    public void setStateParameter(String name, String value) {
        this.context.getStateParams().setParameter(name, value);
    }

    @Override
    public String localize(String id) {
        return this.localize(id, null);
    }

    @Override
    public String localize(String id, Object[] args) {
        return this.localize(this.getProductLocale(), id, args);
    }

    @Override
    public String localize(Locale locale, String id, Object[] args) {
        return this.messagesMgrImpl.localize(locale, id, args);
    }

    @Override
    public String getUniqueID() {
        return this.id;
    }

    @Override
    public String getTransientParameter(String name) {
        return this.context.getTransientParams().getValue(name);
    }

    @Override
    public void addTransientUpdate(TransientUpdate transientUpdate) {
        if (transientUpdate != null) {
            Iterator iter = transientUpdate.iterator();
            while (iter.hasNext()) {
                Parameters.NameValuePair nvp = (Parameters.NameValuePair)iter.next();
                String name = nvp.getName();
                String value = transientUpdate.getValue(name);
                if (name == null || name.length() <= 0) continue;
                Fragment.TransientUpdate tu = new Fragment.TransientUpdate(this.context.getFragment());
                tu.setName(name);
                tu.setValue(value);
                if (transientUpdate.getChannel() > 0) {
                    tu.setChannel(Integer.toString(transientUpdate.getChannel()));
                }
                if (transientUpdate.getScope() != null) {
                    tu.setScope(transientUpdate.getScope());
                }
                this.context.getFragment().addTransientUpdate(tu);
            }
        }
    }

    @Override
    public String getTimeZone() throws J2HTMLException {
        return this.getBusHeader().getTimeZone();
    }

    @Override
    public Object getClientStateParameter(Component component, String name) throws J2HTMLException {
        try {
            if (!this.clientStateInitialized) {
                String clientState = this.context.getEnv().getParameter(J2HTMLUISTATE_KEY);
                if (clientState != null) {
                    JSONObject jsonClientState = JSONObject.parse((String)clientState);
                    String fragClientState = this.getStateParameter(J2HTMLUISTATE_KEY);
                    this.fragJsonClientState = fragClientState != null ? JSONObject.parse((String)fragClientState) : new JSONObject();
                    for (String key : jsonClientState.keySet()) {
                        this.fragJsonClientState.put((Object)key, jsonClientState.get((Object)key));
                    }
                }
                this.clientStateInitialized = true;
            }
            if (null != this.fragJsonClientState && this.fragJsonClientState.containsKey((Object)name)) {
                return this.fragJsonClientState.get((Object)name);
            }
            return null;
        }
        catch (IOException e) {
            throw new J2HTMLException(e);
        }
    }

    public StageContext getStageContext() {
        return this.context;
    }

    @Override
    public int getNextTableIdx() {
        return this.nextTableIdx++;
    }

    private BusHeader getBusHeader() throws J2HTMLException {
        if (this.busHeader == null) {
            this.busHeader = new BusHeader();
            try {
                this.busHeader.parse(new XMLStreamReaderRecorder("biBusHeader", XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(this.context.getEnv().getBusHeader().toString()))));
            }
            catch (XMLStreamException e) {
                throw new J2HTMLException(e);
            }
            catch (FactoryConfigurationError e) {
                throw new J2HTMLException(e);
            }
        }
        return this.busHeader;
    }

    private Locale getProductLocale() {
        if (this.productLocale == null) {
            this.productLocale = MessagesManager.createLocale((String)this.context.getEnv().getProductLocale());
        }
        return this.productLocale;
    }

    @Override
    public HashSet getUserCapabilities() throws J2HTMLException {
        try {
            return this.getBusHeader().getUserCapabilities();
        }
        catch (NavException e) {
            throw new J2HTMLException(e);
        }
    }

    @Override
    public Object getParameter(String name) {
        return this.context.getParam(name);
    }

    @Override
    public String getSessionParameter(String name) {
        return this.env.getSessionParameter(name);
    }
}

