/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html.table;

import com.cognos.admin.j2html.Table;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.table.ISortFilterTableModel;
import com.cognos.admin.j2html.table.ITableModel;
import com.cognos.admin.j2html.table.TableColumnFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;

public class DefaultSortFilterTableModel
extends AbstractTableModel
implements ISortFilterTableModel {
    private static final long serialVersionUID = 1L;
    private ArrayList rows;
    private int[] sortColumns;
    private boolean ascending = true;
    private String tableSummary = null;
    protected Row[] rowsArray = new Row[0];
    protected ITableModel dataModel;
    protected Table table;

    public DefaultSortFilterTableModel(Table table) {
        this.table = table;
        this.dataModel = table.getModel();
    }

    @Override
    public int getColumnCount() {
        return this.dataModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            this.init();
        }
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.dataModel.getValueAt(this.rowsArray[row].index, col);
    }

    private void init() {
        this.rows = new ArrayList(this.dataModel.getRowCount());
        for (int r = 0; r < this.dataModel.getRowCount(); ++r) {
            boolean include = true;
            if (this.table.isFilterable()) {
                for (int c = 0; c < this.dataModel.getColumnCount(); ++c) {
                    TableColumnFilter filter;
                    TableColumn column = this.table.getColumn(c);
                    if (column == null || (filter = column.getFilter()) == null || filter.getFilter().contains(this.dataModel.getValueAt(r, this.table.getColumn(c).getModelIndex()))) continue;
                    include = false;
                    break;
                }
            }
            if (!include) continue;
            Row row = new Row();
            this.rows.add(row);
            row.index = r;
        }
        this.rowsArray = this.rows.toArray(this.rowsArray);
        if (this.table.isSortable()) {
            for (int c = 0; c < this.dataModel.getColumnCount(); ++c) {
                TableColumn column = this.table.getColumn(c);
                if (column == null || !column.isSorted()) continue;
                this.sortColumns = new int[]{c};
                this.ascending = column.isAscending();
                Arrays.sort(this.rowsArray, this.table.getSortFromIdx(), this.table.getSortToIdx());
                break;
            }
        }
    }

    @Override
    public void sort(int col, boolean ascending) {
        this.sort(new int[]{0, col}, ascending, this.rowsArray, 0, -1);
    }

    @Override
    public void sort(int col, boolean ascending, int fromIdx, int toIdx) {
        this.sort(new int[]{0, col}, ascending, this.rowsArray, fromIdx, toIdx);
    }

    @Override
    public void sort(int[] cols, boolean ascending) {
        this.sort(cols, ascending, this.rowsArray, 0, -1);
    }

    @Override
    public void sort(TableColumn column, boolean ascending) {
        this.sort(column.getModelIndex(), column.isAscending());
    }

    @Override
    public void sort(TableColumn[] columns, boolean ascending) {
        int[] cols = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            cols[i] = columns[i].getModelIndex();
        }
        this.sort(cols, ascending);
    }

    private void sort(int[] cols, boolean ascending, Row[] rowsArray, int fromIdx, int toIdx) {
        this.sortColumns = cols;
        if (this.rows == null) {
            this.init();
        }
        this.ascending = ascending;
        Arrays.sort(rowsArray, fromIdx, toIdx > 0 ? toIdx : this.getRowCount());
    }

    @Override
    public String getSummary() {
        return this.tableSummary != null && !this.tableSummary.isEmpty() ? this.tableSummary : this.dataModel.getSummary();
    }

    public void setSummary(String tableSummary) {
        this.tableSummary = tableSummary;
    }

    protected class Row
    implements Comparable {
        public int index;
        private Row otherRow;
        private int colIdx = 0;

        protected Row() {
        }

        public int compareTo(Object other) {
            this.otherRow = (Row)other;
            return this.compare(DefaultSortFilterTableModel.this.sortColumns[this.colIdx]);
        }

        private int compare(int col) {
            Comparator comparator = DefaultSortFilterTableModel.this.table.getColumnComparator(col);
            Object a = DefaultSortFilterTableModel.this.dataModel.getValueAt(this.index, col);
            Object b = DefaultSortFilterTableModel.this.dataModel.getValueAt(this.otherRow.index, col);
            int compare = comparator != null ? (DefaultSortFilterTableModel.this.ascending ? comparator.compare(a, b) : comparator.compare(b, a)) : (a instanceof Comparable ? (DefaultSortFilterTableModel.this.ascending ? ((Comparable)a).compareTo(b) : ((Comparable)b).compareTo(a)) : this.index - this.otherRow.index);
            if (compare == 0 && this.colIdx > DefaultSortFilterTableModel.this.sortColumns.length - 1) {
                return this.compare(DefaultSortFilterTableModel.this.table.getColumn(DefaultSortFilterTableModel.this.sortColumns[this.colIdx++]).getModelIndex());
            }
            this.colIdx = 0;
            return compare;
        }
    }
}

