/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.j2html.table;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TableColumnFilter {
    private List filter;
    private boolean inclusive = true;
    private int column = 0;

    public TableColumnFilter(String encodedFilter) {
        this.decoder(encodedFilter);
    }

    public TableColumnFilter(Object[] filter, int column) {
        this(filter, column, true);
    }

    public TableColumnFilter(Object[] filter, int column, boolean inclusive) {
        this.setFilter(filter);
        this.column = column;
        this.inclusive = inclusive;
    }

    public static TableColumnFilter decode(String encodedFilter) {
        return new TableColumnFilter(encodedFilter);
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    public void setFilter(Object[] filter) {
        this.filter = Arrays.asList(filter);
    }

    public List getFilter() {
        return this.filter;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getColumn()).append(':').append(this.inclusive).append(':');
        Iterator iter = this.filter.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append(';');
        }
        return sb.toString();
    }

    private void decoder(String encodedFilter) {
        String[] tokens = encodedFilter.split(":");
        for (int i = 0; i < tokens.length; ++i) {
            switch (i) {
                case 0: {
                    this.column = Integer.parseInt(tokens[i]);
                }
                case 1: {
                    this.inclusive = tokens[i].equals("true");
                }
                case 2: {
                    this.filter = Arrays.asList(tokens[i].split(";"));
                }
            }
        }
    }
}

