/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca.service;

import com.cognos.accman.autoca.CertRequestHandler;
import com.cognos.accman.autoca.PingRequestHandler;
import com.cognos.accman.autoca.RequestHandler;
import com.cognos.accman.autoca.StopRequestHandler;
import com.cognos.accman.autoca.XmlCaRequest;
import com.cognos.accman.autoca.XmlCertRequest;
import com.cognos.accman.autoca.XmlPingRequest;
import com.cognos.accman.autoca.XmlStopRequest;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.pogo.pdk.BIBusEnvelope;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class BIBusRequestHandlerFactory {
    private static IPFTraceLogger logTrace = new IPFTraceLogger("Trace.CAM.JCAM.autoCA");

    public static RequestHandler create(String string) {
        logTrace.logEnter();
        XmlCaRequest xmlCaRequest = XmlCaRequest.fromString((String)string);
        CertRequestHandler certRequestHandler = null;
        if (xmlCaRequest != null) {
            if (xmlCaRequest.getRequest() instanceof XmlCertRequest) {
                logTrace.trace("Found XmlCertREquest");
                certRequestHandler = new CertRequestHandler((XmlCertRequest)xmlCaRequest.getRequest());
            } else if (xmlCaRequest.getRequest() instanceof XmlStopRequest) {
                logTrace.trace("Found XmlStopRequest");
                certRequestHandler = new StopRequestHandler((XmlStopRequest)xmlCaRequest.getRequest());
            } else if (xmlCaRequest.getRequest() instanceof XmlPingRequest) {
                logTrace.trace("Found XmlPingRequest");
                certRequestHandler = new PingRequestHandler((XmlPingRequest)xmlCaRequest.getRequest());
            } else {
                logTrace.trace("Found unkonwn request type");
            }
        } else {
            logTrace.trace("caReq is null");
        }
        logTrace.logExit();
        return certRequestHandler;
    }

    public static RequestHandler create(BIBusEnvelope bIBusEnvelope, InternetHeaders internetHeaders) {
        logTrace.logEnter();
        Element element = bIBusEnvelope.getBody();
        if (element == null) {
            logTrace.logExit("Cert request body is null");
            return null;
        }
        element.detach();
        Document document = DocumentHelper.createDocument((Element)element);
        Node node = document.selectSingleNode("/*[local-name()='Body']/*[local-name()='caRequest']");
        String string = null;
        try {
            logTrace.trace("Creating XML from cert");
            string = node.asXML();
        }
        catch (Exception exception) {
            logTrace.logExit("Exception while converting cert into XML", exception);
            return null;
        }
        logTrace.logExit();
        return BIBusRequestHandlerFactory.create(string);
    }
}

