/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca.service;

import com.cognos.accman.autoca.service.autoCAPassThroughCommand;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import java.io.IOException;
import java.util.Iterator;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.soap.util.mime.MimeUtils;

public class autoCAFinder
extends BasicHandler {
    private static Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(autoCAFinder.class.getName());
    private static IPFTraceLogger logTrace = new IPFTraceLogger("Trace.CAM.JCAM.autoCA");
    private static final String CA_SOAP_ACTION = "\"http://developer.cognos.com/schemas/autoCAService/1\"";

    public autoCAFinder() {
        super(category);
    }

    public void invokeImpl(MessageContext messageContext) throws PogoException {
        logTrace.logEnter();
        InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty("request.headers");
        BIBusEnvelope bIBusEnvelope = (BIBusEnvelope)messageContext.getProperty("request.envelope");
        Iterator iterator = (Iterator)messageContext.getProperty("request.attachments");
        logTrace.trace("Creating new autoCAPassThroughCommand");
        autoCAPassThroughCommand autoCAPassThroughCommand2 = new autoCAPassThroughCommand(bIBusEnvelope, internetHeaders);
        if (iterator != null) {
            autoCAPassThroughCommand2.setRequestAttachments(iterator);
        }
        autoCAPassThroughCommand2.setAutoRelease(false);
        try {
            logTrace.trace("Execute cmCommand");
            autoCAPassThroughCommand2.execute();
        }
        catch (CommandExecutionException commandExecutionException) {
            messageContext.setFault(new Fault("MALFORMED_REQUEST", (Exception)((Object)commandExecutionException)));
            logTrace.logExit((Exception)((Object)commandExecutionException));
            return;
        }
        logTrace.trace("Get command response Envelope");
        BIBusEnvelope bIBusEnvelope2 = autoCAPassThroughCommand2.getResponseEnvelope();
        if (bIBusEnvelope2 == null) {
            messageContext.setFault(new Fault("MALFORMED_REQUEST"));
            logTrace.logExit("Response was null");
            return;
        }
        logTrace.trace("Copy the response.");
        messageContext.setResponseName("response");
        messageContext.setProperty("response.envelope", (Object)autoCAPassThroughCommand2.getResponseEnvelope());
        messageContext.setProperty("response.headers", (Object)autoCAPassThroughCommand2.getResponseMIMEHeaders());
        messageContext.setProperty("response.status_code", (Object)Integer.toString(autoCAPassThroughCommand2.getStatusCode()));
        messageContext.setProperty("response.status_msg", (Object)autoCAPassThroughCommand2.getStatusString());
        Iterator iterator2 = autoCAPassThroughCommand2.getAttachments();
        if (iterator2.hasNext()) {
            messageContext.setProperty("response.attachments", (Object)iterator2);
            messageContext.setProperty("response.boundary", (Object)MimeUtils.getUniqueValue());
        }
        try {
            logTrace.trace("Responding");
            messageContext.respond("response");
        }
        catch (IOException iOException) {
            logTrace.logExit("Response failed", (Exception)iOException);
            category.debug("autoCAFinder request failed", (Throwable)iOException);
        }
        logTrace.logExit();
    }
}

