/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca.service;

import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.pogo.bibus.BIBusPassThroughCommand;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.StandaloneServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.net.URL;
import javax.mail.internet.InternetHeaders;

public class autoCAPassThroughCommand
extends BIBusPassThroughCommand {
    private static final String CA_SOAP_ACTION = "\"http://developer.cognos.com/schemas/autoCAService/1\"";
    private static IPFTraceLogger logTrace = new IPFTraceLogger("Trace.CAM.JCAM.autoCA");

    public autoCAPassThroughCommand(BIBusEnvelope bIBusEnvelope, InternetHeaders internetHeaders) {
        super(bIBusEnvelope, internetHeaders);
    }

    protected void addExtraHTTPHeaders(ServerConnection serverConnection) {
        logTrace.logEnter();
        super.addExtraHTTPHeaders(serverConnection);
        serverConnection.setRequestHeader("SOAPAction", CA_SOAP_ACTION);
        logTrace.logExit();
    }

    protected String fetchRequestContext() {
        logTrace.logEnter();
        Configuration configuration = Configuration.getInstance();
        String string = null;
        try {
            logTrace.trace("Get CA URL or path");
            URL uRL = configuration.getCAUrl();
            if (uRL == null) {
                return null;
            }
            string = uRL.getPath();
        }
        catch (Exception exception) {
            logTrace.logExit("Fail get CA URL or path", exception);
        }
        logTrace.logExit();
        return string;
    }

    protected ServerConnection fetchServerConnection() {
        int n;
        URL uRL;
        boolean bl;
        String string;
        block7: {
            logTrace.logEnter();
            string = null;
            bl = false;
            logTrace.trace("Get configuration instance");
            Configuration configuration = Configuration.getInstance();
            try {
                logTrace.trace("Get CA URL");
                uRL = configuration.getCAUrl();
                if (uRL == null) {
                    logTrace.logExit("CA URL is null");
                    return null;
                }
                string = uRL.getHost();
                n = uRL.getPort();
                String string2 = uRL.getProtocol();
                if (string2.equalsIgnoreCase("https")) {
                    bl = true;
                    logTrace.trace("Found SSL connection");
                    break block7;
                }
                if (string2.equalsIgnoreCase("http")) {
                    logTrace.trace("Found non-SSL connection");
                    bl = false;
                    break block7;
                }
                logTrace.logExit("Found unknown protocol");
                return null;
            }
            catch (Exception exception) {
                logTrace.logExit("Error determining CA URL", exception);
                return null;
            }
        }
        uRL = null;
        try {
            logTrace.trace("Creating standalone server");
            uRL = new StandaloneServerConnection(string, n, bl);
        }
        catch (Exception exception) {
            logTrace.trace("Error creating standalone server", exception);
        }
        logTrace.logExit();
        return uRL;
    }
}

