/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca;

import org.dom4j.Element;

public class XmlCertResponse {
    public String shaHMAC;
    public String hmac;
    public String hmacAlgorithm;
    public String requestedCert;
    public String caCert;

    public static XmlCertResponse fromElement(Element certResponseElem) {
        if (certResponseElem.getNamespaceURI().compareTo("http://developer.cognos.com/schemas/autoCAService/1/") != 0 || certResponseElem.getName().compareTo("certResponse") != 0) {
            return null;
        }
        String hmacAlg = certResponseElem.attributeValue("hmacAlgorithm");
        if (hmacAlg == null || hmacAlg.length() == 0) {
            return XmlCertResponse.fromElement1(certResponseElem);
        }
        return XmlCertResponse.fromElement2(certResponseElem, hmacAlg);
    }

    private static XmlCertResponse fromElement1(Element certResponseElem) {
        XmlCertResponse newCertResponse = new XmlCertResponse();
        Element requestedCertElem = certResponseElem.element("requestedCert");
        if (requestedCertElem == null) {
            return null;
        }
        newCertResponse.shaHMAC = certResponseElem.attributeValue("sha1HMAC");
        Element x509dataElem = requestedCertElem.element("x509data");
        if (x509dataElem == null) {
            return null;
        }
        newCertResponse.requestedCert = x509dataElem.getText();
        Element caCertElem = certResponseElem.element("caCert");
        if (caCertElem == null) {
            return null;
        }
        x509dataElem = caCertElem.element("x509data");
        if (x509dataElem == null) {
            return null;
        }
        newCertResponse.caCert = x509dataElem.getText();
        return newCertResponse;
    }

    private static XmlCertResponse fromElement2(Element certResponseElem, String hmacAlg) {
        XmlCertResponse newCertResponse = new XmlCertResponse();
        Element requestedCertElem = certResponseElem.element("requestedCert");
        if (requestedCertElem == null) {
            return null;
        }
        newCertResponse.hmac = certResponseElem.attributeValue("HMAC");
        newCertResponse.hmacAlgorithm = hmacAlg;
        Element x509dataElem = requestedCertElem.element("x509data");
        if (x509dataElem == null) {
            return null;
        }
        newCertResponse.requestedCert = x509dataElem.getText();
        Element caCertElem = certResponseElem.element("caCert");
        if (caCertElem == null) {
            return null;
        }
        x509dataElem = caCertElem.element("x509data");
        if (x509dataElem == null) {
            return null;
        }
        newCertResponse.caCert = x509dataElem.getText();
        return newCertResponse;
    }

    public String toString() {
        if (this.hmacAlgorithm == null || this.hmacAlgorithm.length() == 0) {
            return "<certResponse sha1HMAC=\"" + this.shaHMAC + "\">" + "<" + "requestedCert" + "><" + "x509data" + ">" + this.requestedCert + "</" + "x509data" + "></" + "requestedCert" + ">" + "<" + "caCert" + "><" + "x509data" + ">" + this.caCert + "</" + "x509data" + "></" + "caCert" + ">" + "</" + "certResponse" + ">";
        }
        return "<certResponse HMAC=\"" + this.hmac + "\"" + " " + "hmacAlgorithm" + "=\"" + this.hmacAlgorithm + "\">" + "<" + "requestedCert" + "><" + "x509data" + ">" + this.requestedCert + "</" + "x509data" + "></" + "requestedCert" + ">" + "<" + "caCert" + "><" + "x509data" + ">" + this.caCert + "</" + "x509data" + "></" + "caCert" + ">" + "</" + "certResponse" + ">";
    }
}

