/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CryptoHttpClient;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.misc.HttpClientInitializer;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.res.MessageSet;
import java.net.InetAddress;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.httpclient.HttpConnection;

public class HttpClientFactory
extends DefaultAdditionalInfoHandler {
    private IConfiguration configData;
    private boolean bInitialized;
    private Hashtable httpClientTable;
    private Vector httpRemovedClientList;
    private Vector httpRemovedClientIdList;
    private int clientId;
    private int removedIndex;

    public HttpClientFactory(IConfiguration configuration) throws CAMCryptoException {
        this.initialize(configuration);
    }

    private void initialize(IConfiguration config) throws CAMCryptoException {
        this.httpClientTable = new Hashtable();
        this.httpRemovedClientList = new Vector();
        this.httpRemovedClientIdList = new Vector();
        this.clientId = 1;
        this.removedIndex = 1;
        try {
            this.httpRemovedClientList.add(this.removedIndex - 1, null);
            this.httpRemovedClientIdList.add(this.removedIndex - 1, null);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_index_out_of_range"));
        }
        this.configData = config;
    }

    public HttpConnection createHttpConnection() throws CAMCryptoException {
        HttpConnection con;
        new IPFTraceFunction("createHttpConnection", this).logEntry();
        try {
            URL urlPeer = this.configData.getPeer();
            con = HttpClientInitializer.getInstance().createHttpConnection(urlPeer.getHost(), urlPeer.getPort(), this.configData.isPeerConnectionSSL());
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpConnection", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpConnection", this).logExit(con);
        return con;
    }

    public HttpConnection createHttpConnection(String host, int port, boolean secure) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpConnection", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        HttpConnection con = HttpClientInitializer.getInstance().createHttpConnection(host, port, secure);
        new IPFTraceFunction("createHttpConnection", this).logExit(con);
        return con;
    }

    public Integer createHttpClient() throws CAMCryptoException {
        Integer cryptoHttpClientKey;
        new IPFTraceFunction("createHttpClient", this).logEntry();
        try {
            URL urlPeer = this.configData.getPeer();
            int port = urlPeer.getPort();
            String host = urlPeer.getHost();
            cryptoHttpClientKey = this.clientId;
            this.addClient(cryptoHttpClientKey, this.getHttpClient(this.createHttpClient(host, port, this.configData.isPeerConnectionSSL())));
            ++this.clientId;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(cryptoHttpClientKey);
        return cryptoHttpClientKey;
    }

    public Integer createHttpClient(String host, int port) throws CAMCryptoException {
        Integer cryptoHttpClientKey;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpClient", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            cryptoHttpClientKey = this.clientId;
            this.addClient(cryptoHttpClientKey, this.getHttpClient(this.createHttpClient(host, port, this.configData.isHostConnectionSSL(host, port))));
            ++this.clientId;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(cryptoHttpClientKey);
        return cryptoHttpClientKey;
    }

    public Integer createHttpClient(InetAddress host, int port) throws CAMCryptoException {
        Integer cryptoHttpClientKey;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpClient", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            String hostname = host.getHostName();
            cryptoHttpClientKey = this.clientId;
            this.addClient(cryptoHttpClientKey, this.getHttpClient(this.createHttpClient(host, port, this.configData.isHostConnectionSSL(host.getHostName(), port))));
            ++this.clientId;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(cryptoHttpClientKey);
        return cryptoHttpClientKey;
    }

    public Integer createHttpClient(String host, int port, boolean secure) throws CAMCryptoException {
        Integer cryptoHttpClientKey;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpClient", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            CryptoHttpClient chc = HttpClientInitializer.getInstance().createCryptoHttpClient(host, port, secure);
            cryptoHttpClientKey = this.clientId;
            this.addClient(cryptoHttpClientKey, chc);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(cryptoHttpClientKey);
        return cryptoHttpClientKey;
    }

    public Integer createHttpClient(InetAddress host, int port, boolean secure) throws CAMCryptoException {
        Integer cryptoHttpClientKey;
        IPFTraceFunction ipfFunction = new IPFTraceFunction("createHttpClient", this);
        ipfFunction.addParameter("host", host);
        ipfFunction.addParameter("port", port);
        ipfFunction.addParameter("secure", secure);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            CryptoHttpClient chc = HttpClientInitializer.getInstance().createCryptoHttpClient(host.getHostName(), port, secure);
            cryptoHttpClientKey = this.clientId;
            this.addClient(cryptoHttpClientKey, chc);
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("createHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("createHttpClient", this).logExit(cryptoHttpClientKey);
        return cryptoHttpClientKey;
    }

    public void deleteHttpClient(Integer httpConnectionId) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("deleteHttpClient", this);
        ipfFunction.addParameter("httpConnectionId", httpConnectionId);
        ipfFunction.logEntry();
        ipfFunction = null;
        try {
            CryptoHttpClient cryptoHttpClient;
            try {
                cryptoHttpClient = (CryptoHttpClient)((Object)this.httpClientTable.remove(httpConnectionId));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_index_out_of_range"));
            }
            try {
                this.httpRemovedClientList.add(this.removedIndex, cryptoHttpClient);
                this.httpRemovedClientIdList.add(this.removedIndex, httpConnectionId);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_index_out_of_range"));
            }
            ++this.removedIndex;
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("deleteHttpClient", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("deleteHttpClient", this).logExit();
    }

    public CryptoHttpClient restartHttpClient(Integer httpConnectionId) throws CAMCryptoException {
        CryptoHttpClient cryptoHttpClient;
        block9: {
            IPFTraceFunction ipfFunction = new IPFTraceFunction("restartHttpClient", this);
            ipfFunction.addParameter("httpConnectionId", httpConnectionId);
            ipfFunction.logEntry();
            ipfFunction = null;
            try {
                cryptoHttpClient = null;
                if (this.httpRemovedClientIdList.contains(httpConnectionId)) {
                    int i = this.httpRemovedClientIdList.indexOf(httpConnectionId);
                    try {
                        cryptoHttpClient = (CryptoHttpClient)((Object)this.httpRemovedClientList.get(i));
                        this.httpRemovedClientList.remove(i);
                        this.httpRemovedClientIdList.remove(i);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_index_out_of_range"));
                    }
                    try {
                        this.httpClientTable.put(httpConnectionId, cryptoHttpClient);
                    }
                    catch (NullPointerException e) {
                        throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_httpclientfactory_null_pointer_exception"));
                    }
                    String host = cryptoHttpClient.getHost();
                    int port = cryptoHttpClient.getPort();
                    boolean secure = cryptoHttpClient.getSecure();
                    HttpClientInitializer.getInstance().resetCryptoHttpClient(cryptoHttpClient);
                    --this.clientId;
                    ++this.removedIndex;
                    break block9;
                }
                Integer newClientId = this.createHttpClient();
                cryptoHttpClient = this.getHttpClient(newClientId);
                try {
                    this.httpClientTable.put(newClientId, cryptoHttpClient);
                }
                catch (NullPointerException e) {
                    throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_httpclientfactory_null_pointer_exception"));
                }
            }
            catch (CAMCryptoException e) {
                new IPFAuditFunction("restartHttpClient", this).logExit(e);
                throw e;
            }
        }
        new IPFTraceFunction("restartHttpClient", this).logExit((Object)cryptoHttpClient);
        return cryptoHttpClient;
    }

    private void addClient(Integer key, CryptoHttpClient chc) throws CAMCryptoException {
        try {
            this.httpClientTable.put(key, chc);
        }
        catch (NullPointerException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_httpclientfactory_null_pointer_exception"));
        }
    }

    public CryptoHttpClient getHttpClient(Integer httpConnectionId) throws CAMCryptoException {
        IPFTraceFunction ipfFunction = new IPFTraceFunction("getHttpClient", this);
        ipfFunction.addParameter("httpConnectionId", httpConnectionId);
        ipfFunction.logEntry();
        ipfFunction = null;
        CryptoHttpClient client = (CryptoHttpClient)((Object)this.httpClientTable.get(httpConnectionId));
        new IPFTraceFunction("getHttpClient", this).logExit((Object)client);
        return client;
    }
}

