/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarSecuritySession {
    private static JarSecuritySession singleton = null;
    private PKIXParameters pkixParams = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarSecuritySession() {
        FileInputStream is = null;
        try {
            String cacertsfile = System.getProperty("java.home");
            cacertsfile = cacertsfile + "/lib/security/cacerts".replace('/', File.separatorChar);
            is = new FileInputStream(cacertsfile);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            String password = "changeit";
            keystore.load(is, password.toCharArray());
            this.pkixParams = new PKIXParameters(keystore);
            this.pkixParams.setRevocationEnabled(false);
        }
        catch (Exception e) {
            IPFTraceFunction.trace("JarSecuritySession::JarSecuritySession(): Failed to load JRE file.");
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static synchronized JarSecuritySession getInstance() {
        if (singleton == null) {
            singleton = new JarSecuritySession();
        }
        return singleton;
    }

    public boolean verifyJar(File jar) throws Exception {
        try {
            JarFile jarFile = new JarFile(jar, true);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return false;
            }
            Map<String, Attributes> manMap = manifest.getEntries();
            if (manMap.isEmpty()) {
                return false;
            }
            String entryName = null;
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                boolean isSigned;
                JarEntry jarEntry = entries.nextElement();
                entryName = jarEntry.getName();
                if (manifest.getAttributes(entryName) == null && manifest.getAttributes("./" + entryName) == null && manifest.getAttributes("/" + entryName) == null) continue;
                this.verifyJarEntry(jarFile, jarEntry);
                Certificate[] certs = jarEntry.getCertificates();
                boolean bl = isSigned = certs != null && certs.length > 0;
                if (!isSigned) {
                    return false;
                }
                boolean bTrustChain = this.verifyCertificateChain(certs);
                if (bTrustChain) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void verifyJarEntry(JarFile jar, JarEntry entry) throws SecurityException, IOException {
        InputStream is = jar.getInputStream(entry);
        byte[] buffer = new byte[8192];
        int n = 0;
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
        }
        is.close();
    }

    private boolean verifyCertificateChain(Certificate[] certChain) throws CertificateException, NoSuchAlgorithmException, CAMCryptoException {
        CertificateFactory cf;
        if (certChain == null || certChain.length == 0) {
            return false;
        }
        if (this.pkixParams == null) {
            IPFTraceFunction.trace("JarSecuritySession::verifyCertificateChain - Init error.");
            return false;
        }
        try {
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                cf = CertificateFactory.getInstance("X.509", jceProvider);
            } else {
                cf = CertificateFactory.getInstance("X.509");
            }
        }
        catch (NoSuchProviderException e1) {
            IPFTraceFunction.trace("JarSecuritySession::verifyCertificateChain - Cannot create CertificateFactory.");
            return false;
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (int i = 0; i < certChain.length; ++i) {
            Principal subject;
            ByteArrayInputStream bais = new ByteArrayInputStream(certChain[i].getEncoded());
            X509Certificate thisCert = (X509Certificate)cf.generateCertificate(bais);
            Principal issuer = thisCert.getIssuerDN();
            boolean bCertSelfSigned = issuer.equals(subject = thisCert.getSubjectDN());
            if (bCertSelfSigned) continue;
            certList.add(thisCert);
        }
        CertPath certPath = cf.generateCertPath(certList);
        CertPathValidatorResult result = null;
        try {
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            result = validator.validate(certPath, this.pkixParams);
        }
        catch (Exception e) {
            IPFTraceFunction.trace("JarSecuritySession::verifyCertificateChain - Validator object init error.");
            return false;
        }
        return true;
    }
}

