/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.LoggableObject;
import com.cognos.accman.jcam.crypto.misc.IPFFunction;
import com.cognos.accman.jcam.crypto.misc.IPFSwitch;
import com.cognos.accman.res.MessageSet;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogTypedLogger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class IPFAuditFunction
extends IPFFunction {
    private static final int LEVEL = 10000;
    private static LogTypedLogger auditLogger;
    private static boolean loggedFIPSMode;

    public IPFAuditFunction(String functionName, LoggableObject callerObject) {
        super(functionName, callerObject);
    }

    public static void fatal(String message) {
        IPFAuditFunction.logMessage(message, "Fatal", 50000);
    }

    public static void fatalException(String message, Exception exception) {
        IPFAuditFunction.logMessage(message, "Fatal", 50000, exception);
    }

    public static void error(String message) {
        IPFAuditFunction.logMessage(message, "Error", 40000);
    }

    public static void errorException(String message, Exception exception) {
        IPFAuditFunction.logMessage(message, "Error", 40000, exception);
    }

    public static void warn(String message) {
        IPFAuditFunction.logMessage(message, "Wan", 30000);
    }

    public static void warnException(String message, Exception exception) {
        IPFAuditFunction.logMessage(message, "Warn", 30000, exception);
    }

    private static void logMessage(String message, String logStatus, int logLevel, Exception exception) {
        String exceptionMessage = message + " due to exception: " + exception.toString();
        IPFAuditFunction.logMessage(exceptionMessage, logStatus, logLevel);
    }

    private static void logMessage(String message, String logStatus, int logLevel) {
        if (!IPFFunction.isEnabled(auditLogger, logLevel)) {
            return;
        }
        String logMessage = "<messages><message><messageString><![CDATA[ s" + message + "]]</messageString></message></messages>";
        LogAuditAccessIndication ind = new LogAuditAccessIndication("jcam", IPFFunction.s_version);
        ind.setStatus(logStatus);
        ind.setLevel(logLevel);
        ind.setErrorMessage(logMessage);
        auditLogger.log((Object)ind);
    }

    public static boolean isEnabled() {
        return IPFFunction.isEnabled(auditLogger, 10000);
    }

    public static void logFIPSMode() {
        if (IPFFunction.isEnabled(auditLogger, 50000) && !loggedFIPSMode) {
            LogAuditIndication ind = new LogAuditIndication("jcam", IPFFunction.s_version);
            ind.setLevel(50000);
            ind.setLogData(MessageSet.getMessage("CAM_CAP_fips_mode_on"));
            auditLogger.log((Object)ind);
            loggedFIPSMode = true;
        }
    }

    public static void trace(String message) {
        if (!IPFAuditFunction.isEnabled()) {
            return;
        }
        String callMethod = IPFFunction.getCaller(1);
        StringBuffer traceEntry = new StringBuffer("<trace>");
        traceEntry.append("<message");
        if (message == null) {
            traceEntry.append(">(NULL)</message>");
        } else if (message.length() == 0) {
            traceEntry.append("/>");
        } else {
            traceEntry.append("><![CDATA[" + callMethod + ": " + message + "]]></message>");
        }
        traceEntry.append("</trace>");
        LogAuditIndication ind = new LogAuditIndication("jcam", IPFFunction.s_version);
        ind.setLevel(10000);
        ind.setLogData(traceEntry.toString());
        auditLogger.log((Object)ind);
    }

    public void logEntry() {
        if (!IPFAuditFunction.isEnabled()) {
            return;
        }
        LogAuditIndication ind = new LogAuditIndication("jcam", IPFFunction.s_version);
        super.logEntry((LogIndication)ind);
        ind.setLevel(10000);
        ind.setOperation("CallStart");
        ind.setLogData(this.logData.toString());
        auditLogger.log((Object)ind);
    }

    public void logExit() {
        if (!IPFAuditFunction.isEnabled()) {
            return;
        }
        this.logExit("(void)", "void");
    }

    public void logExit(Exception thrownException) {
        if (!IPFAuditFunction.isEnabled()) {
            return;
        }
        StringWriter stackWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stackWriter);
        thrownException.printStackTrace(pw);
        pw.flush();
        this.logData.append("<exception><![CDATA[" + thrownException.toString() + "]]");
        this.logData.append("<stack><![CDATA[" + stackWriter.toString() + "]]</stack>");
        this.logData.append("</exception>");
        LogAuditAccessIndication ind = new LogAuditAccessIndication("jcam", IPFFunction.s_version);
        super.logExit((LogIndication)ind);
        ind.setLevel(10000);
        ind.setOperation("CallEnd");
        ind.setErrorMessage(this.logData.toString());
        auditLogger.log((Object)ind);
    }

    public void logExit(boolean returnValue) {
        this.logExit(String.valueOf(returnValue), "boolean");
    }

    public void logExit(Object returnValue) {
        this.logExit(returnValue.toString(), returnValue.getClass().getName());
    }

    private void logExit(String returnValue, String type) {
        this.logData.append("<returnvalue");
        if (returnValue == null) {
            this.logData.append(">(NULL)</returnvalue>");
        } else if (returnValue.length() == 0) {
            this.logData.append("/>");
        } else {
            this.logData.append("><![CDATA[" + returnValue + "]]></returnvalue>");
        }
        LogAuditAccessIndication ind = new LogAuditAccessIndication("jcam", IPFFunction.s_version);
        super.logExit((LogIndication)ind);
        ind.setLevel(10000);
        ind.setOperation("CallEnd");
        ind.setErrorMessage(this.logData.toString());
        auditLogger.log((Object)ind);
    }

    static {
        loggedFIPSMode = false;
        try {
            if (IPFSwitch.isSwitchedOn()) {
                auditLogger = LogTypedLogger.getInstance((String)"Audit.RTUsage.CAM.JCAM", LogAuditIndication.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

