/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.LoggableObject;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogTypedLogger;

public class IPFFunction {
    private final String sessionID;
    private final String requestID;
    private final String stepID;
    protected StringBuffer logData = new StringBuffer();
    protected static int s_version;
    protected static final String componentName = "jcam";

    protected IPFFunction(String functionName, LoggableObject callerObject) {
        this.logData.append("<function name=\"" + functionName + "\">");
        this.logData.append("<parameters>");
        this.addParameter("this", callerObject.toString() + ":" + Integer.toString(callerObject.getClassInstanceID()));
        this.sessionID = callerObject.getSessionContext();
        this.requestID = callerObject.getRequestContext();
        this.stepID = callerObject.getStepContext();
    }

    protected IPFFunction(String functionName) {
        this.logData.append("<function name=\"" + functionName + "\">");
        this.logData.append("<parameters>");
        this.sessionID = null;
        this.requestID = null;
        this.stepID = null;
    }

    protected IPFFunction() {
        this.sessionID = null;
        this.requestID = null;
        this.stepID = null;
    }

    protected static boolean isEnabled(LogTypedLogger logger, int level) {
        return logger != null && logger.isEnabled(level);
    }

    private void _addParameter(String name, String value) {
        this.logData.append("<parameter name=\"" + name + "\"");
        if (value.length() == 0) {
            this.logData.append("/>");
        } else {
            this.logData.append("><![CDATA[" + value + "]]></parameter>");
        }
    }

    public void addParameter(String parameterName, boolean value) {
        this._addParameter(parameterName, value ? "true" : "false");
    }

    public void addParameter(String parameterName, byte[] value) {
        if (value == null) {
            this._addParameter(parameterName, "(NULL)");
        } else {
            this._addParameter(parameterName, value.toString());
        }
    }

    public void addParameter(String parameterName, int value) {
        this._addParameter(parameterName, Integer.toString(value));
    }

    public void addParameter(String parameterName, Object value) {
        if (value == null) {
            this._addParameter(parameterName, "(NULL)");
        } else {
            this._addParameter(parameterName, value.toString());
        }
    }

    protected void logEntry(LogIndication ind) {
        this.logData.append("</parameters></function>");
        ind.setSessionID(this.sessionID);
        ind.setRequestID(this.requestID);
        ind.setStepID(this.stepID);
    }

    protected void logExit(LogIndication ind) {
        this.logData.append("</parameters></function>");
        ind.setSessionID(this.sessionID);
        ind.setRequestID(this.requestID);
        ind.setStepID(this.stepID);
    }

    protected void resetLogData() {
        this.logData = new StringBuffer();
    }

    private static final String getCaller_markerABCXYZ(int level) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            if (!stack[i].getMethodName().equals("getCaller_markerABCXYZ")) continue;
            if (i + level >= stack.length) break;
            return stack[i + level].getClassName() + "." + stack[i + level].getMethodName();
        }
        return "unknown_class.unknown_method[" + stack[stack.length - 1].getClassName() + "." + stack[stack.length - 1].getMethodName() + "]";
    }

    protected static String getCaller(int level) {
        return IPFFunction.getCaller_markerABCXYZ(level + 2);
    }

    static {
        try {
            Package jcam = Package.getPackage("com.cognos.accman.jcam.crypto");
            String version = jcam.getImplementationVersion();
            if (version == null) {
                version = "x.y.9999.z";
            }
            int lastDot = version.lastIndexOf(46);
            int secondLastDot = version.lastIndexOf(46, lastDot - 1);
            s_version = Integer.parseInt(version.substring(secondLastDot + 1, lastDot));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

