/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbcinfo;

import com.ibm.cognos.jdbc.adaptor.BaseConnectionAdaptor;
import com.ibm.cognos.jdbc.adaptor.ConnectionFactory;
import com.ibm.cognos.jdbcinfo.Action;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class App {
    private boolean junit = false;
    private String driverClass = "com.ibm.db2.jcc.DB2Driver";
    private String URL = "jdbc:db2://host:port/database";
    private String user = "user";
    private String password = "password";
    private Driver driver;
    private Properties credentials;
    private Connection connection;
    private DatabaseMetaData databaseMetadata;
    private static List<Action> knownActions = new ArrayList<Action>();
    private List<Action> actions = new ArrayList<Action>();

    private static ArrayList<String> getClassNamesInPackage(String pkgName) throws IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        String dirName = pkgName.replace('.', '/');
        URL url = App.class.getResource("/" + dirName);
        if (!url.toString().startsWith("jar:")) {
            String inputStreamString = new Scanner(url.openStream(), "UTF-8").useDelimiter("\\A").next();
            for (String name : inputStreamString.split("\\s")) {
                if (!name.endsWith(".class")) continue;
                classNames.add(pkgName + "." + name.substring(0, name.length() - 6));
            }
        } else {
            JarFile jf = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                String simpleName;
                String name = entries.nextElement().getName();
                if (!name.startsWith(dirName) || !name.endsWith(".class") || (simpleName = name.substring(dirName.length() + 1, name.length() - 6)).contains("/")) continue;
                classNames.add(pkgName + "." + simpleName);
            }
        }
        return classNames;
    }

    private static void registerActions() throws IOException {
        String pkgName = App.class.getPackage().getName();
        for (String className : App.getClassNamesInPackage(pkgName)) {
            try {
                Object o = Class.forName(className).newInstance();
                if (!(o instanceof Action)) continue;
                Action a = (Action)o;
                knownActions.add(a);
            }
            catch (Exception exception) {}
        }
        Collections.sort(knownActions);
        for (Action a : knownActions) {
            System.out.printf("Found action: %s %s%n", a.getName(), a.getUsage());
        }
    }

    private void parseArgs(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-u")) {
                this.user = args[++i];
                ++i;
                continue;
            }
            if (args[i].equals("-p")) {
                this.password = args[++i];
                ++i;
                continue;
            }
            if (args[i].equals("-d")) {
                this.driverClass = args[++i];
                ++i;
                continue;
            }
            if (args[i].equals("-U")) {
                this.URL = args[++i];
                ++i;
                continue;
            }
            if (args[i].equals("-junit")) {
                ++i;
                this.junit = true;
                continue;
            }
            boolean ok = false;
            for (Action action : knownActions) {
                if (!action.isMatch(args[i])) continue;
                ++i;
                i = action.consumeArguments(i, args);
                knownActions.remove(action);
                int index = 0;
                for (Action a : this.actions) {
                    if (action.getPriority() > a.getPriority()) break;
                    ++index;
                }
                this.actions.add(index, action);
                ok = true;
                break;
            }
            if (ok) continue;
            throw new Exception("Invalid command line option: " + args[i]);
        }
        if (this.actions.isEmpty()) {
            throw new Exception("You must specify an action.");
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public Driver getDriver() throws Exception {
        if (this.driver == null) {
            System.out.println("* attempting to load driver... ");
            this.driver = (Driver)Class.forName(this.driverClass).newInstance();
            if (this.driver == null) {
                throw new Exception("* Driver is null");
            }
            System.out.println("* Driver loaded.");
        }
        return this.driver;
    }

    public Properties getCredentials() {
        if (this.credentials == null) {
            this.credentials = new Properties();
            this.credentials.setProperty("user", this.user);
            this.credentials.setProperty("password", this.password);
        }
        return this.credentials;
    }

    public Connection getConnection() throws Exception {
        if (this.connection == null) {
            if (!this.getDriver().acceptsURL(this.URL)) {
                throw new Exception(String.format("Driver %s does not support the URL: %s", this.driverClass, this.URL));
            }
            System.out.println("* attempting to connect...");
            try {
                this.connection = ConnectionFactory.createAndWrapConnection((Driver)this.getDriver(), (String)this.URL, (Properties)this.getCredentials());
            }
            catch (Throwable t) {
                System.out.println(t);
                this.connection = this.getDriver().connect(this.URL, this.getCredentials());
            }
            if (this.connection == null) {
                throw new Exception("* connection is null");
            }
            try {
                if (this.connection instanceof BaseConnectionAdaptor) {
                    System.out.println("* connected via " + this.connection.getClass().getSimpleName());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("* connected.");
        }
        return this.connection;
    }

    public DatabaseMetaData getDatabaseMetadata() throws Exception {
        if (this.databaseMetadata == null) {
            System.out.println("* attempting to get metadata from connection ...");
            this.databaseMetadata = this.getConnection().getMetaData();
            if (this.databaseMetadata == null) {
                throw new Exception("* metadata object is null");
            }
            System.out.println("* successfully created metadata object.");
        }
        return this.databaseMetadata;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void setURL(String uRL) {
        this.URL = uRL;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getURL() {
        return this.URL;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    private void go(String[] args) throws Throwable {
        block10: {
            try {
                this.parseArgs(args);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println("USAGE:");
                System.out.println("You must specify the class path and actions as follows,");
                if (App.isWindows()) {
                    System.out.println("java -cp '<JDBCDRIVERDIR>\\*;.\\jdbcinfo.jar' com.ibm.cognos.jdbcinfo.App [args] [action [parameters]]");
                } else {
                    System.out.println("java -cp '<JDBCDRIVERDIR>/*:./jdbcinfo.jar' com.ibm.cognos.jdbcinfo.App [args] [action [parameters]]");
                }
                System.out.println("    where args are:");
                System.out.println("          -u user ID");
                System.out.println("          -p password");
                System.out.println("          -d driver class");
                System.out.println("          -U JDBC connection url");
                System.out.println("    and [action [parameters]] is one or more actions listed above.");
                return;
            }
            System.out.println("configuration:");
            System.out.println("Java version: " + System.getProperty("java.version"));
            System.out.println("Java vendor: " + System.getProperty("java.vendor"));
            System.out.println("Java vm name: " + System.getProperty("java.vm.name"));
            System.out.printf("Using classpath %s%n", System.getProperty("java.class.path"));
            System.out.println();
            try {
                for (Action action : this.actions) {
                    System.out.printf("Action %s:%n", action.getName());
                    action.go(this);
                    System.out.println();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                if (!this.junit) break block10;
                throw e;
            }
        }
        if (this.connection != null) {
            System.out.println("closing connection ...");
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static void main(String[] args) throws Throwable {
        try {
            App.registerActions();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        App app = new App();
        app.go(args);
    }
}

