/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbcinfo;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class InterfaceValidator {
    public static void validate(Class<?> expectedInterface, Object actualObject, Hints hints) {
        Class<?> actualClass = actualObject.getClass();
        System.out.printf("Validating %s implementation in %s.%n", expectedInterface.getName(), actualClass.getName());
        if (!expectedInterface.isInstance(actualObject)) {
            System.out.printf("    %s does not implement %s%n", actualClass.getName(), expectedInterface.getName());
        }
        System.out.printf("Inspecting fields.%n", new Object[0]);
        InterfaceValidator.validateFields(expectedInterface, actualClass, actualObject);
        System.out.printf("%nInspecting methods.%n", new Object[0]);
        InterfaceValidator.validateMethods(expectedInterface, actualClass, actualObject, hints);
    }

    private static void validateFields(Class<?> expectedInterface, Class<?> actualClass, Object actualObject) {
        Field[] fields = expectedInterface.getFields();
        Arrays.sort(fields, new FieldComparator());
        for (Field expectedField : fields) {
            System.out.println(expectedField.toString());
            Class<?> expectedType = expectedField.getType();
            try {
                Field actualField = actualClass.getField(expectedField.getName());
                Class<?> actualType = actualField.getType();
                if (!actualType.equals(expectedType)) {
                    System.out.printf("    Type is %s instead of %s.%n", actualType.getName(), expectedType.getName());
                }
                try {
                    Object result = actualField.get(actualObject);
                    System.out.printf("    Field value is [%s]%n", String.valueOf(result));
                }
                catch (IllegalArgumentException e) {
                    System.out.printf("    IllegalArgumentException while accessing field in %s.%n", actualClass.getName());
                }
                catch (IllegalAccessException e) {
                    System.out.printf("    Field is not visible.%n", new Object[0]);
                }
            }
            catch (SecurityException e1) {
                System.out.printf("    SecurityException while getting field from %s.%n", actualClass.getName());
            }
            catch (NoSuchFieldException e1) {
                System.out.printf("    Field is undefined in %s%n", actualClass.getName());
            }
        }
    }

    private static void validateMethods(Class<?> expectedInterface, Class<?> actualClass, Object actualObject, Hints hints) {
        Method[] methods = expectedInterface.getMethods();
        Arrays.sort(methods, new MethodComparator());
        for (Method expectedMethod : methods) {
            System.out.println(expectedMethod.toString());
            Class<?>[] parameterTypes = expectedMethod.getParameterTypes();
            Class<?> expectedReturnType = expectedMethod.getReturnType();
            try {
                Hint hint;
                Method actualMethod = actualClass.getMethod(expectedMethod.getName(), parameterTypes);
                Class<?> actualReturnType = actualMethod.getReturnType();
                if (!actualReturnType.equals(expectedReturnType)) {
                    System.out.printf("    Declared return type is %s instead of %s.%n", actualReturnType.getName(), expectedReturnType.getName());
                }
                if ((hint = (Hint)hints.get(expectedMethod.getName())) == null) {
                    hint = new Hint();
                }
                if (hint.arguments.length == parameterTypes.length) {
                    try {
                        Object result = actualMethod.invoke(actualObject, hint.arguments);
                        System.out.printf("    Method returned [%s]%n", String.valueOf(result));
                        if (result == null || expectedReturnType.isPrimitive() || expectedReturnType.isInstance(result)) continue;
                        System.out.printf("    Returned object is %s not an instance of %s.%n", result.getClass().getName(), expectedReturnType.getName());
                    }
                    catch (IllegalArgumentException e) {
                        System.out.printf("    Method does not accept arguments %s.%n", String.valueOf(hint.arguments));
                    }
                    catch (IllegalAccessException e) {
                        System.out.printf("    Method is not visible.%n", new Object[0]);
                    }
                    catch (InvocationTargetException u) {
                        Throwable cause = u.getCause();
                        boolean isADeclaredException = false;
                        for (Class<?> exception : expectedMethod.getExceptionTypes()) {
                            if (!exception.isInstance(cause)) continue;
                            isADeclaredException = true;
                            break;
                        }
                        if (!isADeclaredException) {
                            System.out.printf("    Method threw undeclared exception %s.%n", cause.toString());
                            continue;
                        }
                        System.out.printf("    Method threw exception %s.%n", cause.toString());
                    }
                    continue;
                }
                System.out.println("Method skipped.");
            }
            catch (SecurityException e) {
                System.out.printf("    SecurityException while getting method from %s.%n", actualClass.getName());
            }
            catch (NoSuchMethodException e) {
                System.out.printf("    Method is undefined in %s.%n", actualClass.getName());
            }
        }
    }

    public static final class Hint {
        private static final Object[] NOARGS = new Object[0];
        private static final String[] NOSTRINGS = new String[0];
        private static final Class<?>[] NOCLASSES = new Class[0];
        public Object[] arguments = NOARGS;
        public String[] resultsetColumnNames = NOSTRINGS;
        public Class<?>[] resultsetColumnTypes = NOCLASSES;

        public Hint(Object[] args, String[] names, Class<?>[] types) {
            this.arguments = args;
            this.resultsetColumnNames = names;
            this.resultsetColumnTypes = types;
        }

        public Hint() {
        }

        public Hint(boolean ev, Object[] args) {
            this.arguments = args;
        }
    }

    private static final class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static final class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static final class Hints
    extends HashMap<String, Hint> {
        private static final long serialVersionUID = 6106875601160249300L;
    }
}

