/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbcinfo;

import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class RowSet {
    ResultSet resultSet;

    public RowSet(ResultSet rs) throws SQLException {
        this.resultSet = rs;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        try {
            int rowCount = 0;
            while (this.resultSet.next()) {
                ResultSetMetaData metadata = this.resultSet.getMetaData();
                ++rowCount;
                for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                    String contents;
                    if (metadata.getColumnType(i) == 2006) {
                        Ref ref = this.resultSet.getRef(i);
                        contents = "reference to: '" + ref.getBaseTypeName() + "'";
                    } else {
                        contents = this.resultSet.getString(i);
                    }
                    buffer.append(String.format("%8d   %s (%s): %s%n", rowCount, metadata.getColumnName(i), metadata.getColumnTypeName(i), contents));
                }
                buffer.append('\n');
            }
            System.out.printf("%d rows returned.%n", rowCount);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }
}

