/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbcinfo;

import com.ibm.cognos.jdbcinfo.Action;
import com.ibm.cognos.jdbcinfo.App;
import com.ibm.cognos.jdbcinfo.RowSet;
import java.sql.ResultSet;
import java.sql.Statement;

public class SqlAction
extends Action {
    private static final int PREPARE_EXECUTE_MODE = 1;
    private static final int PREPARE_EXECUTEQUERY_MODE = 2;
    private static final int CREATE_EXECUTE_MODE = 4;
    private static final int CREATE_EXECUTEQUERY_MODE = 8;

    public SqlAction() {
        this.numParameters = 2;
        this.usage = "<mode bitmask> <SQL query>, for bitmask, bit 0=prepare(sql)/execute, bit 1=prepare(sql)/executeQuery, bit 2=create/execute(sql), bit 3=create/executeQuery(sql).";
    }

    @Override
    public void go(App app) throws Exception {
        int mask = Integer.parseInt(this.parameters[0]);
        while (mask != 0) {
            Statement statement;
            ResultSet rs = null;
            if ((mask & 1) != 0) {
                --mask;
                System.out.printf("Mode 0x1: Connection.PrepareStatement( '%s' )%n", this.parameters[1]);
                statement = app.getConnection().prepareStatement(this.parameters[1]);
                System.out.printf("PreparedStatement.execute()%n", new Object[0]);
                statement.execute();
                rs = statement.getResultSet();
            } else if ((mask & 2) != 0) {
                mask -= 2;
                System.out.printf("Mode 0x2: Connection.PrepareStatement( '%s' )%n", this.parameters[1]);
                statement = app.getConnection().prepareStatement(this.parameters[1]);
                System.out.printf("PreparedStatement.executeQuery()%n", new Object[0]);
                statement.executeQuery();
                rs = statement.getResultSet();
            } else if ((mask & 4) != 0) {
                mask -= 4;
                System.out.printf("Mode 0x04: Connection.CreateStatement()%n", new Object[0]);
                statement = app.getConnection().createStatement();
                System.out.printf("Statement.execute( '%s' )%n", this.parameters[1]);
                statement.execute(this.parameters[1]);
                rs = statement.getResultSet();
            } else if ((mask & 8) != 0) {
                mask -= 8;
                System.out.printf("Mode 0x08: Connection.CreateStatement()%n", new Object[0]);
                statement = app.getConnection().createStatement();
                System.out.printf("Statement.executeQuery( '%s' )%n", this.parameters[1]);
                statement.executeQuery(this.parameters[1]);
                rs = statement.getResultSet();
            }
            if (rs == null) continue;
            System.out.printf("fetching it...%n", new Object[0]);
            System.out.println(new RowSet(rs));
            rs.close();
        }
    }
}

